#ifndef LoadCell_h
#define LoadCell_h

#include "mbed.h"
#include "Maths.h"

class LoadCell
{
private:
    AnalogIn ain;
    int SAMPLE_AMOUNT;
    float CALIBRATION_MASS;
    float TARE_VALUE;
    float CALIBRATION_VALUE;  
    float OFFSET;  
    float DOWN_OFFSET;  


public:
    LoadCell(PinName pin);
    float analogRead();
    float simpleAnalogRead();
    float calculateMass(float value);
    float tare();
    float tareDown();
    float callibrate();
    float mass();
    float simpleMass();
    void setCalibrationMass(int);
    void setSampleAmount(int);
          
};

#endif





