#include "Maths.h"
#include "mbed.h"

int Maths::comp(const void* elem1, const void* elem2)
{
    if(*(const float*)elem1 < *(const float*)elem2)
        return -1;
    return *(const float*)elem1 > *(const float*)elem2;
}

float Maths::mean(float *samples, int n, int n2)
{
    float sum = 0.0;
    for (int i=0; i<n2-n; i++) {
        sum += samples[n+i];
    }
    return sum / (float)(n2-n);
}

float Maths::median(float *samples, int n)
{
    qsort(samples, n, sizeof(float), Maths::comp);

    return mean(samples, (n - 1)/2 - 990,(n - 1)/2 + 990);
}

float Maths::stdev(float data[] , int n)
{
    float sum = 0.0, mean2, standardDeviation = 0.0;
    int i;
    mean2 = Maths::mean(data,0,n);

    for(i = 0; i < n; ++i)
        standardDeviation += pow(data[i] - mean2, 2);

    return sqrt(standardDeviation / n);
}


float Maths::meanNoOutliers(float data[] , int n)
{
    float mean = Maths::mean(data,0,n);
    float stdev = Maths::stdev(data,n);
    float amount = 0;
    float sum  = 0;
    for(int i = 0; i < n; ++i) {
        if (data[i] <= mean + 1*stdev && data[i] >= mean - 1*stdev) {
            amount ++;
            sum += data[i];
        }
    }
    return sum/amount;


}
