#include "LoadCell.h"

LoadCell::LoadCell(PinName pin): ain(pin)
{
    SAMPLE_AMOUNT = 2000;
    CALIBRATION_MASS = 843.56; // 274.19
    TARE_VALUE = 0.743027;
    CALIBRATION_VALUE = 0.725960;
    OFFSET = TARE_VALUE-CALIBRATION_VALUE;
    DOWN_OFFSET = 0.023591;
};


float LoadCell::analogRead()
{
    float samples [SAMPLE_AMOUNT];
    for(int i = 0; i < SAMPLE_AMOUNT; i++) {
        float read =ain.read();
        samples [i] =read;
    }
    return Maths::mean(samples,0,SAMPLE_AMOUNT);
}

float LoadCell::simpleAnalogRead()
{
    return ain.read();
}

float LoadCell::calculateMass(float value)
{
    return ((TARE_VALUE - value)*(CALIBRATION_MASS))/(OFFSET);
}


float LoadCell::tare()
{
    TARE_VALUE = 0;
    float values[20];
    for (int a = 0; a<20; a++) {
        values[a] = analogRead();
    }

    TARE_VALUE = Maths::mean(values,0,20);
    return TARE_VALUE;
}

float LoadCell::tareDown()
{
    TARE_VALUE = 0;
    float values[20];
    for (int a = 0; a<20; a++) {
        values[a] = analogRead();
    }

    TARE_VALUE = Maths::mean(values,0,20)- DOWN_OFFSET;
    return TARE_VALUE;
}

float LoadCell::callibrate()
{
    CALIBRATION_VALUE = analogRead();
    return CALIBRATION_VALUE;
}


float LoadCell::mass()
{
    return calculateMass(analogRead());
}

float LoadCell::simpleMass()
{
    return calculateMass(simpleAnalogRead());
}


void LoadCell::setCalibrationMass(int mass)
{
    CALIBRATION_MASS = mass;
}

void LoadCell::setSampleAmount(int samples)
{
    SAMPLE_AMOUNT = samples;
}


