#include "mbed.h"
#include "Transmitter.h"
#include "Maths.h"
#include "LoadCell.h"

Serial pc(USBTX, USBRX);
Ontvanger tx;
LoadCell test(A0);
InterruptIn reedSensor(D9);
Ticker sampler;
Timer t;


int reed = 0;

int DEBUG_ENABLED = 0;
int meet = 0;
float val2[10000];
int VAL_AM = 0;


const int BEFORE_AMOUNT = 1;
float BEFORE_VALUES[BEFORE_AMOUNT];
int BEFORE_COUNTER = 0;

const int REED_AMOUNT = 1;
float REED_VALUES[REED_AMOUNT][BEFORE_AMOUNT];
int REED_COUNTER = 0;
int REED_ENABLE = 0;

int MAGNET_COUNTER = 0;

void log(const char* format, ...)
{
    if (DEBUG_ENABLED) {
        char buffer[256];
        va_list args;
        va_start(args, format);
        vsprintf(buffer, format, args);
        pc.printf("DEBUG - %s \r\n", buffer);
        va_end(args);
    }
}

void send(float mass)
{
    tx.update();
    payload_t payload;
    payload.command = 0x01;
    payload.mass = mass;
    log("Writing now");
    bool ok = tx.write(payload);
    log("Done writing");
    if (ok)
        log("Ok");
    else
        log("Failed");
}


void sendCommand (char c)
{
    switch (c) {
        case 't':
            float tare = test.tare();
            log("Tare %f", tare);
            send(tare);
            break;
        case 'T':
            float tare2 = test.tareDown();
            log("Tare %f", tare2);
            send(tare2);
            break;
        case 'c':
            float cali = test.callibrate();
            log("Callibrate %f", cali);
            send(cali);
            break;
        case 'y':
            float volt = test.analogRead();
            log("Voltage %f", volt);
            send(volt);
            break;
        case 'm':
            float mass = test.mass();
            log("MASS %f", mass);
            send(mass);
            break;
            case 'M':
            float mass2 = test.simpleMass();
            log("MASS %f", mass2);
            send(mass2);
            break;
        case 'P':
            for (int i = 0; i<10000; i++) {
                send(val2[i]);
                wait_ms(25);
            }
            break;
        case 'p':
            float test[REED_AMOUNT];
            float test2[REED_AMOUNT];

            for (int i = 0; i<REED_AMOUNT; i++) {
                for (int j = 0; j<BEFORE_AMOUNT; j++) {
                    send(REED_VALUES[i][j]);
                    printf("%f,",REED_VALUES[i][j]);
                }
                printf("\r\n");
                send(999);

                test[i] = Maths::mean(REED_VALUES[i],0,BEFORE_AMOUNT-1);
                test2[i] = Maths::meanNoOutliers(REED_VALUES[i],BEFORE_AMOUNT-1);
            }
            send(999);
            send(Maths::mean(test,0,REED_AMOUNT));
            send(999);
            send(Maths::meanNoOutliers(test,REED_AMOUNT));
            send(999);
            send(Maths::meanNoOutliers(test2,REED_AMOUNT));
            send(999);

            break;
        case 'r':
            REED_ENABLE = !REED_ENABLE;
            memset( REED_VALUES, 0, sizeof( REED_VALUES ) );
            memset( BEFORE_VALUES, 0, sizeof( BEFORE_VALUES) );
            REED_COUNTER = 0;
            break;
    };
}
void readNF24()
{
    tx.update();
    if (tx.available()) {
        payload_t payload;
        payload = tx.read();
        pc.printf("%c\r\n", payload.command);
        sendCommand(payload.command);
    }
}

void reedS()
{
    if (REED_ENABLE)
        reed = 1;
}

void getSample()
{
    if (REED_ENABLE) {
        val2[VAL_AM] = test.simpleAnalogRead();
        VAL_AM = (VAL_AM + 1) %10000;
    }
}

void init()
{
    DEBUG_ENABLED = 0;
    log("INITIALISE");
    log("DEBUGGING IS: ON");
    log("Load cell using: Analog Pin A2");
    log("Transmitter using: D4, D3, A1, A6, A5");
    tx.printDetails();

    log("INIT REED SENSOR");

    reedSensor.fall(&reedS);
    reedSensor.mode(PullUp);
    sampler.attach(&getSample, 0.00004);

}


void receive()
{
    while (true) {
        pc.printf("");//print niet weg doen, één of andere reden werkt het niet zonder
        tx.update();
        if (tx.available()) {
            payload_t payload;
            payload = tx.read();
            if(!payload.messageAvailable) {
                pc.printf("%f\r\n", payload.mass);
            }
        }
    }
}





void readPc()
{
    if(pc.readable()) {
        sendCommand(pc.getc());
    }
}

void readReed()
{
    if(reed) {
        /*for (int i = 0; i <BEFORE_AMOUNT ; i++)
            REED_VALUES[REED_COUNTER][i] = BEFORE_VALUES[(i+BEFORE_COUNTER) % BEFORE_AMOUNT];
        REED_COUNTER=(REED_COUNTER+1) % REED_AMOUNT;

        MAGNET_COUNTER++;
        */
        REED_ENABLE = 0;
        send(VAL_AM);
        reed = 0;

    }
}

int main()
{
    init();
    while (1) {
        //If reed is enabled
        if(!REED_ENABLE) {
            readPc();
            readNF24();
        } else {
            readReed();
            /*val2[VAL_AM] = test.simpleAnalogRead();
            VAL_AM = (VAL_AM + 1) %10000;
            */
            /*BEFORE_VALUES[BEFORE_COUNTER] = test.mass();
            BEFORE_COUNTER ++;
            BEFORE_COUNTER = BEFORE_COUNTER % BEFORE_AMOUNT;
            if(MAGNET_COUNTER >= REED_AMOUNT) {
                MAGNET_COUNTER = 0;
                REED_ENABLE = !REED_ENABLE;
            }*/
        }
    }

}
