#include "Transmitter.h"

Serial pc2(USBTX, USBRX);
RF24 radio(spi_MOSI, spi_MISO, spi_SCK, nrf_CE, nrf_CSN );
RF24Network network(radio);

RF24NetworkHeader header_rx;

Ontvanger::Ontvanger()
{
    radio.begin();
    network.begin(90, this_node);
    wait_ms(2000);
    radio.setPALevel(RF24_PA_MIN);
    radio.setDataRate(RF24_250KBPS);
};

void Ontvanger::update()
{
    network.update();
}

bool Ontvanger::available()
{
    return network.available();
}

void Ontvanger::printDetails()
{
    radio.printDetails();
}

char * Ontvanger::readArray()
{
    char * payload_rx;
    network.read(header_rx,&payload_rx,sizeof(payload_rx));
    return payload_rx;
}

bool Ontvanger::writeArray(char * message)
{
    RF24NetworkHeader header_tx(other_node);
    char packet[128];
    strcpy(packet,message);
    
    return network.write(header_tx,&packet,sizeof(packet));
}


payload_t Ontvanger::read()
{
    payload_t payload_rx;
    network.read(header_rx,&payload_rx,sizeof(payload_rx));
    
    
    return payload_rx;
}

bool Ontvanger::write(payload_t message)
{
    RF24NetworkHeader header_tx(other_node);
    payload_t packet;
    packet = message;
    
    return network.write(header_tx,&packet,sizeof(packet));
}

bool Ontvanger::isValid()
{
    return radio.isValid();
}

bool Ontvanger::testRPD()
{
    return radio.testRPD();
}

void Ontvanger::printMessage(char index){
    switch (index) {
      case '1': 
        pc2.printf("Message: Initializing...\n\r");
        break;
      case '2': 
        pc2.printf("Message: Taring...\n\r");
        break;
      case '3': 
        pc2.printf("Message: Error: Tare first\n\r");
        break;
      case '4': 
        pc2.printf("Message: Tare completed\n\r");
        break;
      case '5': 
        pc2.printf("Message: Error: Tare value to low... Retry\n\r");
        break;
      case '6': 
        pc2.printf("Message: Waiting on the right position...\n\r");
        break;
      case '7': 
        pc2.printf("Message: Wait 5 Seconds on POSITION...\n\r");
        break;
      case '8': 
        pc2.printf("Message: ERROR: Not on position\n\r");
        break; 
}
    }


