#ifndef Transmitter_h
#define Transmitter_h
#include "mbed.h"
#include <RF24Network.h>
#include <RF24.h>

#define nrf_CE      D4
#define nrf_CSN     D3
#define spi_SCK     A1
#define spi_MOSI    A6
#define spi_MISO    A5

#ifdef PRINT_ENABLE
    #define IF_PRINT_ENABLE(x) ({x;})
    #else
    #define IF_PRINT_ENABLE(x)
    #endif


//Identification verzender/ontvanger
const uint16_t this_node = 01;
const uint16_t other_node = 00;


//
struct payload_t {
    char command;
    float mass;
    bool messageAvailable;
};

enum State2 {init_state,
             testConnection_state,
             send_state,
             receive_state,
            };

enum State {State_init,
            State_tare,
            State_position,
            State_read,
            State_send,
            State_receive,
            State_calibrate
           };



class Ontvanger
{
private:


public:
    Ontvanger();
    void update();
    bool available();
    void printDetails();
    bool write(payload_t message);
    payload_t read();
    bool writeArray(char *);
    char * readArray();
    bool isValid();
    bool testRPD();
    void printMessage(char index);
};

#endif





