/*
 * wpa_supplicant/hostapd / OS specific functions
 * Copyright (c) 2005-2006, Jouni Malinen <j@w1.fi>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License version 2 as
 * published by the Free Software Foundation.
 *
 * Alternatively, this software may be distributed under the terms of BSD
 * license.
 *
 * See README and COPYING for more details.
 */

#ifndef __NMI_WIFI_ADAPER_H__
#define __NMI_WIFI_ADAPER_H__

#include <stddef.h>
#include <stdarg.h>

//#include "os_api.h"

//#include "wifisupp_api.h"   //ksong 2012.8.28

#include <stdbool.h>
#include <stdint.h>
    /* exact-width signed integer types */
typedef   signed          char int8;
typedef   signed short     int int16;
typedef   signed           int int32;
typedef   signed       __int64 int64;

typedef   signed          char sint8;
typedef   signed short     int sint16;
typedef   signed           int sint32;
typedef   signed       __int64 sint64;

    /* exact-width unsigned integer types */
typedef unsigned          char uint8;
typedef unsigned short     int uint16;
typedef unsigned           int uint32;
typedef unsigned       __int64 uint64;

//#include "nmi_wlan_if.h"	command by Tsungta

#ifdef __cplusplus
extern "C" {
#endif

/*******************************************************************************/
//#define GPIO_WIFI_IRQ_ID 0


#define NMI_INVALID_THREAD_ID    SCI_INVALID_BLOCK_ID


/********************************************

	Debug Flags

********************************************/
#define NMI_INIT			0x00000001
#define NMI_ERR			0x00000002
#define NMI_TX			0x00000004
#define NMI_INTR 		0x00000008
#define NMI_RX			0x00000010
#define NMI_SCAN		0x00000020
#define NMI_JOIN			0x00000040
#define NMI_STATUS		0x00000080
#define NMI_POLL		0x00000100
#define NMI_IF			0x00000200
#define NMI_ALL			0xffffffff

/*******************************************************************************/

typedef unsigned char BOOLEAN;
typedef long os_time_t;
typedef unsigned long       NMI_TCPIP_IP_ADDR_T; 
typedef unsigned long       NMI_TCPIP_NET_ID_T; 
typedef unsigned char	    NMI_BOOLEAN_T;
typedef unsigned long		NMI_BLOCK_ID;
typedef void *  NMI_SCI_EVENT_GROUP_PTR;
typedef void *  NMI_SCI_MUTEX_PTR;
typedef void *  NMI_SCI_SEMAPHORE_PTR;

#if 0//Ryan
typedef enum
{
	NMI_MESSAGE_START = WIFISUPP_SIG_CUSTOM_START,
	NMI_MESSAGE_RESTART_MAC,
	NMI_MESSAGE_POWER_SAVE,
	NMI_MESSAGE_SLEEP,
	NMI_MESSAGE_MAX = WIFISUPP_SIG_CUSTOM_END
}NMI_MESSAGE_E;
#endif

//#define CFLWCHAR        unsigned short    // uni-code char
#define SFS_MAX_PATH    255

// EAPOL data receive upcall function
typedef void (*NMI_TCPIP_EAPOL_RX_CALLBACK_FPTR)( 
    const unsigned char*    data_ptr,       /* EAPOL data pointer */
    unsigned int            data_len,       /* EAPOL data length */
    const unsigned char*    src_mac_ptr,    /* source mac address pointer */
    unsigned int            src_mac_len,    /* source mac length, unit: byte for ethernet, it should be 6 */
    NMI_TCPIP_NET_ID_T      net_id );       /* net interface ID */


// TCPIP interface error enum
typedef enum
{
	NMI_TCPIP_ERROR_OK = 0,     /* no error */
	NMI_TCPIP_ERROR_INVALPARAM, /* invalid parameter */
	NMI_TCPIP_ERROR_INVALNETID, /* invalid net id */
	NMI_TCPIP_ERROR_MEMALLOC,   /* memory alloc fail */
	NMI_TCPIP_ERROR_LOGICAL,    /* calling or running logical error */
	NMI_TCPIP_ERROR_TIMEOUT,    /* time out */
	NMI_TCPIP_ERROR_MAX
} NMI_TCPIP_ERROR_E;


typedef enum
{
	NMI_TCPIP_PKTTYPE_NULL = 0,
	NMI_TCPIP_PKTTYPE_IP,       /* packet is encapsulated as IP */
	NMI_TCPIP_PKTTYPE_ETHER,    /* packet is encapsulated as Ethernet */
	NMI_TCPIP_PKTTYPE_MAX
} NMI_TCPIP_PACKET_TYPE_E;


// TCPIP net interface IP addresses
// NOTES : IP addresses should be in Big-Ending
typedef struct _netif_ipaddr_tag
{
	NMI_TCPIP_IP_ADDR_T  ipaddr;     /* host IP */
	NMI_TCPIP_IP_ADDR_T  snmask;     /* subnet mask */
	NMI_TCPIP_IP_ADDR_T  gateway;    /* gateway */
	NMI_TCPIP_IP_ADDR_T  dns1;       /* primary DNS */
	NMI_TCPIP_IP_ADDR_T  dns2;       /* secondary DNS */
} NMI_TCPIP_NETIF_IPADDR_T;

// TCPIP net interface hardware address
typedef struct _netif_haddr_tag
{
	unsigned char*  addr_ptr;           /* hard address pointer */
	unsigned int    addr_len;           /* hard address length, unit: byte */
} NMI_TCPIP_NETIF_HADDR_T;


// TCPIP packet info struct
typedef struct _packet_info_tag
{
	unsigned char*      data_ptr;   /* data pointer */
	unsigned int        data_len;   /* data length - full packet encapsulation length */
	NMI_TCPIP_NET_ID_T  net_id;     /* net interface ID */
} NMI_TCPIP_PACKET_INFO_T;


typedef unsigned int (*NMI_TCPIP_TX_REQ_FPTR)( 
    const NMI_TCPIP_PACKET_INFO_T*  pkt_info_ptr );

// TCPIP receive flow control setting function 
typedef void (*NMI_TCPIP_RX_FLCTRL_FPTR)(
    NMI_BOOLEAN_T         is_set,     /* flow control flag: TRUE - set; FALSE - not set */
    NMI_TCPIP_NET_ID_T   net_id );   /* net interface ID */



// TCPIP net interface configuration struct
typedef struct _netif_cfg_tag
{
	NMI_TCPIP_PACKET_TYPE_E     pkt_type;       /* packet type between tcpip and low layer */
	NMI_TCPIP_TX_REQ_FPTR       tx_req_fptr;    /* tx function pointer for data sending from tcpip to low layer */
	NMI_BOOLEAN_T               is_async_tx;    /* tx mode: TRUE - async send; FALSE - sync send */
	NMI_TCPIP_NETIF_IPADDR_T    saddr;          /* soft (IP) address */
	NMI_TCPIP_NETIF_HADDR_T     haddr;          /* hard (MAC) address */
	unsigned int                mtu;            /* MTU of the low layer */
	unsigned int                tx_rate;        /* max tx send rate - it's useful in tx flow control */
	NMI_TCPIP_RX_FLCTRL_FPTR    rx_flctrl_fptr; /* rx flow control function pointer, this is optional, can be NULL */
	char*                       netif_name_ptr; /* net interface name, given by low layer, it can be NULL, but we recommend caller set one for better debug */
} NMI_TCPIP_NETIF_CFG_T;


/*******************************************************************************/

/**--------------------------------------------------------------------------*
 **                         MACRO DEFINITION                                 *
 **--------------------------------------------------------------------------*/
#define NMI_WIFISUPP_BSSID_LEN              6               //the length of BSSID in bytes
#define NMI_WIFISUPP_SSID_MAX_LEN           32              //the MAX length of SSID in bytes
#define NMI_WIFISUPP_WEP_IV_LEN             3               //the length of IV in WEP
#define NMI_WIFISUPP_WEP_64BITS_KEY_LEN     8               //the length of 64bits WEP key
#define NMI_WIFISUPP_WEP_128BITS_KEY_LEN    16              //the length of 128bits WEP key
#define NMI_WIFISUPP_WPA_PSK_LEN            64              //the length of WPA PSK
#ifdef WLAN_SUPPORT
#define NMI_WIFISUPP_WAPI_PSK_LEN           64              //the length of WAPI PSK
#endif
#define NMI_WIFISUPP_MAX_FILE_PATH_LEN      SFS_MAX_PATH    //the MAX file path supported
#define NMI_WIFISUPP_WEP_KEY_ID_MAX         4               //the max WEP key ID

#define NMI_WIFISUPP_MAX_USERNAME_LEN       32
#define NMI_WIFISUPP_MAX_PSW_LEN            32
/**--------------------------------------------------------------------------*
 **                         typedef                                          *
 **--------------------------------------------------------------------------*/
/*---------------------------------------------------------------------------*/
/*                          Enum                                             */
/*---------------------------------------------------------------------------*/
typedef enum
{
	NMI_WIFISUPP_NETWORK_MODE_INFRASTRUCTURE,   //infrastructure
	NMI_WIFISUPP_NETWORK_MODE_ADHOC,            //ad-hoc
	NMI_WIFISUPP_NETWORK_MODE_MAX
} NMI_WIFISUPP_NETWORK_MODE_E;

typedef enum
{
	NMI_WIFISUPP_RESULT_SUCC,           //success
	NMI_WIFISUPP_RESULT_FAIL,           //fail
	NMI_WIFISUPP_RESULT_NOT_FOUND,      //the AP is not found
	NMI_WIFISUPP_RESULT_TIMEOUT,        //operation time out
	NMI_WIFISUPP_RESULT_RESTRICTED,     //connection is restricted
	NMI_WIFISUPP_WRONG_PASSPHRASE,
	NMI_WIFISUPP_RESULT_MAX
} NMI_WIFISUPP_RESULT_E;

typedef enum
{
	NMI_WIFISUPP_ENCRYP_PROTOCOL_OPENSYS,   //open system
	NMI_WIFISUPP_ENCRYP_PROTOCOL_WEP,       //WEP
	NMI_WIFISUPP_ENCRYP_PROTOCOL_WPA,       //WPA
	NMI_WIFISUPP_ENCRYP_PROTOCOL_WPA2,      //WPA2
	NMI_WIFISUPP_ENCRYP_PROTOCOL_WAPI,      //WAPI
	NMI_WIFISUPP_ENCRYP_PROTOCOL_MAX
}NMI_WIFISUPP_ENCRYP_PROTOCOL_E;

typedef enum
{
	NMI_WIFISUPP_CIPHER_TKIP,	    //TKIP
	NMI_WIFISUPP_CIPHER_CCMP,		//CCMP
	NMI_WIFISUPP_CIPHER_WEP,        //wep
	NMI_WIFISUPP_CIPHER_SMS4,        //WAPI SMS4
	NMI_WIFISUPP_CIPHER_MAX
}NMI_WIFISUPP_CIPHER_E;

typedef enum
{
	NMI_WIFISUPP_WEP_KEY_TYPE_64BITS,       //64bits_type WEP Key
	NMI_WIFISUPP_WEP_KEY_TYPE_128BITS,      //128bits_type WEP Key
	NMI_WIFISUPP_WEP_KEY_TYPE_MAX
}NMI_WIFISUPP_WEP_KEY_TYPE_E;

typedef enum
{
	NMI_WIFISUPP_WPA_CREDENTIAL_TYPE_PSK,   //WPA using PSK
	NMI_WIFISUPP_WPA_CREDENTIAL_TYPE_EAP,   //WPA using EAP   802.1X
	NMI_WIFISUPP_WPA_CREDENTIAL_TYPE_MAX
}NMI_WIFISUPP_WPA_CREDENTIAL_TYPE_E;

typedef enum
{
	NMI_WIFISUPP_WAPI_CREDENTIAL_TYPE_PSK,   //WAPI using PSK
	NMI_WIFISUPP_WAPI_CREDENTIAL_TYPE_CER,   //WAPI using certificate
	NMI_WIFISUPP_WAPI_CREDENTIAL_TYPE_MAX
}NMI_WIFISUPP_WAPI_CREDENTIAL_TYPE_E;

typedef enum
{
	NMI_WIFISUPP_CREDENTIAL_TYPE_PSK,
	NMI_WIFISUPP_CREDENTIAL_TYPE_RADIUS,
	NMI_WIFISUPP_CREDENTIAL_TYPE_CER,
	NMI_WIFISUPP_CREDENTIAL_TYPE_MAX
}NMI_WIFISUPP_CREDENTIAL_TYPE_E;


typedef enum
{
	NMI_WIFISUPP_WPA_EAP_TYPE_TLS,          //EAP using TLS
	NMI_WIFISUPP_WPA_EAP_TYPE_TTLS,         //EAP using TTLS
	NMI_WIFISUPP_WPA_EAP_TYPE_PEAP,         //EAP using PEAP
	NMI_WIFISUPP_WPA_EAP_TYPE_LEAP,         //EAP using LEAP
	NMI_WIFISUPP_WPA_EAP_TYPE_SIM,          //EAP using SIM
	NMI_WIFISUPP_WPA_EAP_TYPE_AKA,          //EAP using AKA
	NMI_WIFISUPP_WPA_EAP_TYPE_FAST,         //EAP using FAST
	NMI_WIFISUPP_WPA_EAP_TYPE_MAX
} NMI_WIFISUPP_WPA_EAP_TYPE_E;

typedef enum
{
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_CHAP,        //CHAP credential
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_PAP,         //PAP credential
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_MSCHAP,      //MSCHAP credential
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_MSCHAP_V2,   //MACHAP_V2 credential
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_GTC,         //GTC credential
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_MAX
} NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_E;

//bruce add for coexistence: DHCP notice
typedef enum
{
	NMI_WIFISUPP_DHCP_NOTICE_START,		//APP begin to do dhcp
	NMI_WIFISUPP_DHCP_NOTICE_END,			//APP end dhcp
	NMI_WIFISUPP_DHCP_NOTICE_MAX
}NMI_WIFISUPP_DHCP_NOTICE_E;

/*---------------------------------------------------------------------------*/
/*                          Struct                                           */
/*---------------------------------------------------------------------------*/
typedef struct
{
	unsigned char ssid[NMI_WIFISUPP_SSID_MAX_LEN];
	unsigned char ssid_len;
} NMI_WIFISUPP_SSID_T;  //SSID

typedef struct
{
	unsigned char bssid[NMI_WIFISUPP_BSSID_LEN];
} NMI_WIFISUPP_BSSID_T; //BSSID

typedef struct
{
	NMI_WIFISUPP_SSID_T             ssid;
	NMI_WIFISUPP_BSSID_T            bssid_info;
	signed int                      signal_qua;         //signal quality: RSSI
	unsigned int                    noise;              //SNR: signal noise ratio
	unsigned int                    beacon_interval;    //the BEACON interval
	unsigned int                    channel;            //the channel using
	NMI_WIFISUPP_ENCRYP_PROTOCOL_E  encryp_protocol;    //the protocol used by encryption    
	unsigned int                    rate;               //the rate
	NMI_WIFISUPP_NETWORK_MODE_E     network_mode;       //network mode

	NMI_WIFISUPP_CIPHER_E           pairwise_cipher;
	NMI_WIFISUPP_CIPHER_E		    group_cipher;

	NMI_WIFISUPP_CREDENTIAL_TYPE_E      credential_type;    //AKM type
} NMI_WIFISUPP_SCAN_AP_INFO_T;  //the AP info scanned


typedef struct
{
	unsigned char   psk[NMI_WIFISUPP_WPA_PSK_LEN];
}NMI_WIFISUPP_WPA_PSK_T;    //WPA Pre_shared Key

typedef struct
{
	BOOLEAN         is_use_file;
	unsigned short  certificate_file_path[NMI_WIFISUPP_MAX_FILE_PATH_LEN];  //the tls certificate file path, this MAY NOT available when using buffer
	unsigned char   *certificate_buf_ptr;   //the tls certificate buffer, this MAY NOT available when using file
	unsigned int    certificate_buf_len;    //the tls certificate buffer length, this MAY NOT available when using file
} NMI_WIFISUPP_WPA_EAP_TLS_T;   //EAP_TLS information

typedef struct
{
	NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_E    inner_credential_type;
	char                                    username_arr[NMI_WIFISUPP_MAX_USERNAME_LEN+1];
	char                                    psw_arr[NMI_WIFISUPP_MAX_PSW_LEN+1];
} NMI_WIFISUPP_WPA_EAP_TTLS_PEAP_T; //EAP_TTLS/EAP_PEAP information

typedef struct
{
	char    username_arr[NMI_WIFISUPP_MAX_USERNAME_LEN+1];
	char    psw_arr[NMI_WIFISUPP_MAX_PSW_LEN+1];
}NMI_WIFISUPP_WPA_EAP_LEAP_T;   //EAP_LEAP information

typedef struct
{
	BOOLEAN         is_use_file;
	unsigned short  pac_file_path[NMI_WIFISUPP_MAX_FILE_PATH_LEN];//the FAST PAC file path, this MAY NOT available when using buffer
	unsigned char   *pac_buf_ptr;   //the FAST PAC buffer, this MAY NOT available when using file
	unsigned int    pac_buf_len;    //the FAST PAC buffer length, this MAY NOT available when using file
	char            username_arr[NMI_WIFISUPP_MAX_USERNAME_LEN+1];
	char            psw_arr[NMI_WIFISUPP_MAX_PSW_LEN+1];
}NMI_WIFISUPP_WPA_EAP_FAST_T;   //EAP_FAST information

typedef struct
{
	NMI_WIFISUPP_SSID_T     ssid;
}NMI_WIFISUPP_DISCONNECT_REQ_INFO_T;    //information in the request for disconnecting a connection

typedef struct
{
	NMI_WIFISUPP_WPA_EAP_TYPE_E eap_type;
	union
	{
		NMI_WIFISUPP_WPA_EAP_TLS_T          tls_info;
		NMI_WIFISUPP_WPA_EAP_TTLS_PEAP_T    ttls_info;
		NMI_WIFISUPP_WPA_EAP_TTLS_PEAP_T    peap_info;
		NMI_WIFISUPP_WPA_EAP_LEAP_T         leap_info;
		NMI_WIFISUPP_WPA_EAP_FAST_T         fast_info;
	}eap_info;
} NMI_WIFISUPP_WPA_EAP_T; //WPA EAP information

#ifdef WLAN_SUPPORT
typedef struct
{
	unsigned char   psk[NMI_WIFISUPP_WAPI_PSK_LEN];
}NMI_WIFISUPP_WAPI_PSK_T;

typedef struct
{
	unsigned char    *as_certificate_buf_ptr;
	unsigned int    as_certificate_buf_len; 
	unsigned char    *asue_certificate_buf_ptr;
	unsigned int    asue_certificate_buf_len; 
}NMI_WIFISUPP_WAPI_CER_T;

typedef struct
{
	NMI_WIFISUPP_WAPI_CREDENTIAL_TYPE_E  credential_type;
	union
	{
		NMI_WIFISUPP_WAPI_PSK_T  wapi_psk_info;
		NMI_WIFISUPP_WAPI_CER_T  wapi_cer_info;
	}credential_info;
}NMI_WIFISUPP_WAPI_CREDENTIAL_T;
#endif

typedef struct
{
	NMI_WIFISUPP_WPA_CREDENTIAL_TYPE_E  credential_type;
	union
	{
		NMI_WIFISUPP_WPA_PSK_T  wpa_psk_info;
		NMI_WIFISUPP_WPA_EAP_T  wpa_eap_info;
	}credential_info;
} NMI_WIFISUPP_WPA_CREDENTIAL_T;    //WPA credential information

typedef struct
{
	NMI_WIFISUPP_WEP_KEY_TYPE_E key_type;
	BOOLEAN					    is_open_mode;
	unsigned int		        key_in_use;
	union
	{   
		unsigned char   key_64bits_arr[NMI_WIFISUPP_WEP_KEY_ID_MAX][NMI_WIFISUPP_WEP_64BITS_KEY_LEN - NMI_WIFISUPP_WEP_IV_LEN];
		unsigned char   key_128bits_arr[NMI_WIFISUPP_WEP_KEY_ID_MAX][NMI_WIFISUPP_WEP_128BITS_KEY_LEN - NMI_WIFISUPP_WEP_IV_LEN];
	}key;
} NMI_WIFISUPP_WEP_CREDENTIAL_T;    //WEP credential information

typedef struct
{
	NMI_WIFISUPP_SSID_T             ssid;
	NMI_WIFISUPP_BSSID_T            bssid_info;
	NMI_WIFISUPP_NETWORK_MODE_E     network_mode;
	NMI_WIFISUPP_ENCRYP_PROTOCOL_E  encryp_protocol;
	unsigned int                    channel;
	union
	{
		NMI_WIFISUPP_WEP_CREDENTIAL_T   wep_credential;
		NMI_WIFISUPP_WPA_CREDENTIAL_T   wpa_credential;
	#ifdef WLAN_SUPPORT
		NMI_WIFISUPP_WAPI_CREDENTIAL_T   wapi_credential;
	#endif
	}credential;

	NMI_WIFISUPP_CIPHER_E           pairwise_cipher;
	NMI_WIFISUPP_CIPHER_E           group_cipher;
} NMI_WIFISUPP_SSID_CONFIG_T;   //the config of a SSID

typedef struct
{
	NMI_WIFISUPP_RESULT_E   result;
	NMI_WIFISUPP_SSID_T     ssid;
	NMI_WIFISUPP_BSSID_T    bssid_info;
	unsigned int            channel;
	signed int              rssi;
} NMI_WIFISUPP_CONNECT_RESULT_T;    //connect result

typedef struct 
{
	NMI_WIFISUPP_RESULT_E   result;
	NMI_WIFISUPP_SSID_T     ssid;
} NMI_WIFISUPP_DISCONNECT_RESULT_T; //disconnect result

typedef struct
{
	NMI_WIFISUPP_SSID_T     ssid;
} NMI_WIFISUPP_DISCONNECT_INFO_T;   //disconnect information

typedef struct
{
   // _ATH_SIGNAL_VARS
   	NMI_WIFISUPP_DISCONNECT_INFO_T      disc_info;
} NMI_WIFISUPP_DISCONNECT_IND_T;    //disconnect indication

typedef struct
{
	NMI_WIFISUPP_SSID_T     ssid;
	NMI_WIFISUPP_BSSID_T    new_bssid_info;
	unsigned int            channel;            //the channel using
} NMI_WIFISUPP_BSSID_CHANGED_INFO_T;    //new bssid information

typedef struct
{
	//_ATH_SIGNAL_VARS
	NMI_WIFISUPP_BSSID_CHANGED_INFO_T   bssid_changed_info;
} NMI_WIFISUPP_BSSID_CHANGED_IND_T; //BSSID changed indication

typedef struct
{
	NMI_WIFISUPP_SSID_T     ssid;
	NMI_WIFISUPP_BSSID_T    bssid_info;
	signed int            new_signal_qua;
} NMI_WIFISUPP_RSSI_CHANGED_INFO_T; //RSSI information

typedef struct
{
    //_ATH_SIGNAL_VARS
	NMI_WIFISUPP_RSSI_CHANGED_INFO_T    rssi_changed_info;
} NMI_WIFISUPP_RSSI_CHANGED_IND_T;  //RSSI changed indication

typedef struct
{
	NMI_WIFISUPP_RESULT_E   wifi_on_result;
	unsigned int            net_id;             //the net id got from TCP/IP
	BOOLEAN                 is_support_roam;    //wether support roam
	BOOLEAN                 is_support_protocol[NMI_WIFISUPP_ENCRYP_PROTOCOL_MAX];  //the encrypt protocol supported
	BOOLEAN                 is_support_eap[NMI_WIFISUPP_WPA_EAP_TYPE_MAX];          //the EAP methods supported
	BOOLEAN                 is_support_inner_eap[NMI_WIFISUPP_INNER_CREDENTIAL_TYPE_MAX];   //the inner eap methos supported
} NMI_WIFISUPP_ON_RESULT_T; // wifi on result

typedef struct 
{
	NMI_WIFISUPP_RESULT_E   wifi_off_result;
} NMI_WIFISUPP_OFF_RESULT_T;    //wifi off result

#ifdef WLAN_SUPPORT
typedef struct
{
	NMI_WIFISUPP_SSID_T     ssid;
} NMI_WIFISUPP_SCAN_REQ_INFO_T;

typedef struct
{
	unsigned int is_enter;
	unsigned int threshold; 
}NMI_WIFISUPP_DEEPSLEEP_CMD_INFO_T;

typedef struct
{
	unsigned int is_enable;
	unsigned int interval;
}NMI_WIFISUPP_AUTOSCAN_REQ_INFO_T;

typedef struct
{
	NMI_WIFISUPP_RESULT_E   wifi_autoscan_result;
} NMI_WIFISUPP_AUTOSCAN_RESULT_T;    

typedef struct
{
	//_ATH_SIGNAL_VARS
	NMI_WIFISUPP_AUTOSCAN_RESULT_T  autoscan_result;
} NMI_WIFISUPP_AUTOSCAN_CNF_T;   

typedef struct
{
   // _ATH_SIGNAL_VARS
} NMI_WIFISUPP_SCAN_BEGIN_IND_T;   

#else
typedef struct NMI_WIFISUPP_SCAN_REQ_INFO_tag
{
	NMI_WIFISUPP_SSID_T     ssid;
} NMI_WIFISUPP_SCAN_REQ_INFO_T;
#endif

#if 0//Ryan
typedef struct
{
    _SIGNAL_VARS
    void    *msg_body;
} NMI_WIFISUPP_CUST_MSG_T;    
#endif

typedef enum{
	NMI_DISCONNECTTED = 0,
	NMI_CONNECTTING = 1,
	NMI_CONNECTTED = 2,
	NMI_DISCONNECTTING = 3,
	NMI_MAX
}NMI_STATE_T;

 //Tsungta, 2015/09/05, added for WIFIDevice.apScan() 
typedef struct{
    NMI_WIFISUPP_SSID_T ssid;
    int8_t  ApRssi;         //received signal strength indication of the AP
    uint8_t channelNo;      //channel of the AP, range 1 to 14 
    uint8_t secType;        //security mode of the AP, 0 on no security, 1 on WEP, 2 on WPA, 3 on WPA2       
} scanApInfo;
/*---------------------------------------------------------------------------*/
unsigned char ath_set_eut_mode(uint8 is_enter);
int ath_set_eut_rxtx_channel(int channel);
int ath_set_eut_tx_rate(int ratio);
int ath_set_eut_tx_pwr(int pwr);
unsigned char ath_eut_set_TX_para(unsigned char on_off, int tx_packet_mode);
unsigned char ath_eut_set_RX_para(int rx_command);
unsigned char ath_eut_get_RX_packets(unsigned long *tatal_packets_ptr, unsigned long *err_packets_ptr);
unsigned char ath_eut_set_crystallcap(unsigned char CrystalcapIn,unsigned char CrystalcapOut);

unsigned char ath_eut_get_cal_data(char* pBuf, unsigned int len);
unsigned char ath_eut_update_cal_data(const char* pBuf, unsigned int len);


void nmi_os_trace(char *log);
void nmi_TraceLow(const char * x_format,...);

unsigned int nmi_os_get_ms(void);

unsigned int nmi_os_getSystemTickCount(void);

void nmi_os_sleep_ms(unsigned int msecs);

int nmi_spi_interface_init(void* spi_dma_isr);


uint32 nmi_spi_interface_read( uint8 * buf_ptr, uint32 lenght);


uint32 nmi_spi_interface_write( uint8 * buf_ptr, uint32 lenght);


uint32 nmi_spi_interface_deinit(void* spi_dma_isr);

#ifdef SPI_RW_SEPARATE
uint32 nmi_spi_interface_writeread(uint8 * out_buf_ptr, uint32 out_buf_len, uint8 * in_buf_ptr, uint32 in_buf_len);  //kyu
#else
uint32 nmi_spi_interface_writeread(uint8 * out_buf_ptr, uint8 * in_buf_ptr, uint32 length);  //ksong 2012.7.12
#endif


BOOLEAN nmc1000_wifi_on(void); 
BOOLEAN nmc1000_wifi_off(void); 

void wifi_handle_event(uint8_t * event);//added by Tsungta
void ap_disconnect();//added by Tsungta
void nmc1000_pmk_info_callback(unsigned int ptr, unsigned int len);
void nmc1000_set_pmk_cache_info(uint8_t reset);

void nmc1000_wifi_reset(void);//added by Tsungta, 2015/11/05, due to the change of wifi_core from .c to .cpp
unsigned char nmc1000_wifi_on(void);//added by Tsungta, 2015/11/05, due to the change of wifi_core from .c to .cpp
#ifdef __cplusplus
}
#endif

#endif  /* __NMC1000_WIFI_ADAPER_H__ */



