#ifndef WIFIDEVICE_H_
#define WIFIDEVICE_H_

#include "nmi_wlan_if.h"
#include "nmi_wlan.h"

#include "spi_master.h"

#include "wifi_api.h"
 /** Interface using WI-FI to connect to Ethernet
 *
 */
 
 //Tsungta, 2015/09/05, added for WIFIDevice.apScan() 
typedef struct{
    uint32_t chipID; 
    uint32_t imgStaID; 
    uint32_t imgApID;     
} wifiSpInfo;
 
class WIFIDevice {
public:

  /** Set WIFI in sleep mode.
  * Disable WIFI and set into sleep mode to conserve energy (no WIFI function is available at this point).
  * \return 0 on success, a negative number on failure
  */
  int sleep(void);

  /** Enable the coexistance of WIFI and BLE.
  * Enable the setting of two coexistence control pins (COEX_B and COEX_W) are short to each other.
  * \return 0 on success, a negative number on failure
  */
  int enableCoexistance();

//  /** Set the position of embedded RF switch.
//  * Set the position of RF switch between WIFI and BLE.
//  * \param position set 1 on WIFI to use, set 0 on BLE to use.
//  * \return 0 on success, a negative number on failure
//  */
//  int setSwitch(int position);
//  
//  /** Get the position of embedded RF switch.
//  * Get the current position of RF switch
//  * \return get 1 on WIFI to use, get 0 on BLE to use
//  */
//  int getSwitch(void);
    
  /** Perform WIFI scan.
  * Scan for available access point on all channels.
  * \return number of scanned WIFI access point
  */
  int apScan(void (*eventCallback)(scanApInfo result));
    
  /** Set network connection in priority.
  * Set SSID, password and priority to connect.
  * \param SSID name of access point to connect
  * \param PW password of the given SSID
  * \param priority range from 0 to 2, set 0 for the highest priority
  */
  void setNetwork(char* SSID, char* PW, uint8_t priority);

  /** Set Access Point in given configuration.
  * Set SSID, password, security type and channel in AP mode.
  * \param SSID name of access point in AP mode
  * \param PW password of the given SSID
  * \param security tyoe of security in AP mode (default: (SECURITY_WPA2_AES_PSK)), support
     SECURITY_OPEN          < Open security >
     SECURITY_WEP_PSK       < WEP Security with open authentication with 5/13 ascii characters or 10/26 hex codes passwords
     SECURITY_WEP_SHARED    < WEP Security with shared authentication with 5/13 ascii characters or 10/26 hex codes passwords
     SECURITY_WPA_TKIP_PSK  < WPA Security with TKIP with 8 or more ascii characters passwords
     SECURITY_WPA_AES_PSK   < WPA Security with AES with 8 or more ascii characters passwords 
     SECURITY_WPA2_AES_PSK  < WPA2 Security with AES with 8 or more ascii characters passwords  
     SECURITY_WPA2_TKIP_PSK < WPA2 Security with TKIP with 8 or more ascii characters passwords
     SECURITY_WPA2_MIXED_PSK< WPA2 Security with AES & TKIP with 8 or more ascii characters passwords
  * \param channel range from 1 to 14 (default: (1))
  */
  void WIFIDevice::setAccessPoint(char* SSID, char* PW, security_t security=SECURITY_WPA2_AES_PSK, uint8_t channel=1);

  /** Read WIFI Service Pack version
  ** \return wifiSpInfo
  */
  wifiSpInfo read_WIFI_SP_version();

  /** Erase a 4KB sector of embeeded flash.
  * Flash memory will be erased in groups of 4KB sector.
  * \param address range from 0x00 to 0x3F000 (must be a multiple of 0x1000).
  * \return 0 on success, a negative number on failure
  */  
  int storage_erase4KB(uint32_t address);
  
  /** Write data into embeeded flash.
  * Write one (multiple) byte(s) of data into flash, must perform erase before the flash memory area can be overwrite.
  * \param address flash memory address to be written, range from 0x00 to 0x3FFFF.
  * \param data pointer to the buffer containing data to be written.
  * \param len length of the data to be written to flash.
  * \return 0 on success, a negative number on failure
  */    
  int storage_write(uint32_t address, uint8_t *data, uint16_t len);
  
  /** Read data from embeeded flash.
  * Read one (multiple) byte(s) of data from flash.
  * \param address flash memory address to be read, range from 0x00 to 0x3FFFF.
  * \param data pointer to the buffer containing data to be read.
  * \param len length of the data to be read from flash.
  * \return 0 on success, a negative number on failure
  */     
  int storage_read(uint32_t address, uint8_t *data, uint16_t len);
    
//  /** Get the status of embedded WIFI chipset.
//  * Get the current status of embedded WIFI chipset
//  * \return get 1 on WIFI to use, get 0 on BLE to use
//  */
//  int getStatus(void);
  
//  /** Set WIFI output power.
//  * Set WIFI output power level 
//  * \param output power level
//  * \return 0 on success, a negative number on failure
//  */
//  int setTxPower(uint8_t powerIndex);
  
};

#endif /* WIFIDEVICE_H_ */


