# NNN40 WI-FI SDK version 20160113, release at 2016/1/13
This is the export repo for the WIFI_API provided by Delta Electronics, Inc.

# Highlight of this release
* WIFI_API can be import by any mbed platforms and run as WIFI host via SPI connected with Delta DFCM-NNN40

# Major supported features
* Set TCP maximum payload to 1400 bytes (Max. throughput achieve ~7.5KB)
* Set UDP maximum payload to 1400 bytes (Max. throughput achieve ~20KB)
* Support DNS client for TCP/UDP
* Fast AP re-connection is performed automatically, user can call EthernetInterface.disconnect() to have lowest power consumption of 4uA, then call init and connected to previous AP for less than 4 sec
* Support BLE and WIFI coexistence (refer to WIFIDevice.h)
* Support SoftAP mode (refer to sample code NNN40_WiFi_SoftAP)
* Support Websocket library (refer to sample code NNN40_Websocket)
* Support XmppClient library (refer to sample code NNN40XmppClient)
* Support http server (refer to sample code NNN40_APmodeToSTAmodeByHTTPServer)
* Support http client (refer to sample code NNN40_HTTPClient_GET_POST)

# Roadmap
* Support light weight SSL (modified from CyaSSL)
* Support ARM RTX (RTOS)

# Supported functionalities of embeded Wi-Fi chipset
Currently supported  functionalities include:
* IEEE 802.11 b/g/n connectivity
* Station (STA) infrastructure mode
* Soft AP mode with DHCP server, user must DnD SoftAP_FW_update.hex to DELTA folder to update internal flash (only need to perform once)
* WEP/WPA/WPA2 security
* DHCP Client and Static IPv4 addressing
* TCP Server/Client
* UDP Server/Client
* WIFI BLE coexistence 

# Getting Started 
This WIFI API is meant to be used on Delta NNN40 EVB. 
A good starting point are these pages:
* [WI-FI SDK User Guide](document come with WI-FI SDK deliver) for system overview, APIs summary and sample code
* [EthernetInterface - Handbook](http://developer.mbed.org/handbook/Ethernet-Interface) a simple API that you will need to connect to the internet.
* [Socket - Handbook](http://developer.mbed.org/handbook/Socket) a simple and consistent way to communicate using bsd-like TCP and UDP sockets over WI-FI 
