/* Copyright (c) Cyntec Inc. All Rights Reserved.
 *
 *
 */

#include "wait_api.h"

//#include "nrf_gpio.h"
//#include "boards.h"
#include "nmi_wlan_if.h"
#include "nmi_wlan.h"//Ryan
//extern "C" {
//#include "nmi_wifi_adapter.h"	
//#include "simple_uart.h"
//}	
#include "spi_flash.h"			//added by Tsungta
#include "wifi_core.h"
#include "wifi_api.h"

#include "WIFIDevice.h"
extern u8 wifi_event;//Ryan
extern uint8_t nmi_macaddress[6];
extern bool start_routine;

#include "mbed.h"

#if WIFI_API_DEBUG_LOG
Serial wifi_debug(WIFI_API_DEBUG_TX_PIN, NC);
#endif

DigitalOut  Sleep((PinName) WIFI_SLEEP);
InterruptIn LowInt(WIFI_SPI_IRQN); //Tsungta, 2015/10/02, change for cross-platform compiling

int is_NNN40(void)
{
#if defined(TARGET_DELTA_DFCM_NNN40) 
	return 1;
#else
	return 0;
#endif
}

int parser_ticker_internal = ticker_internal;
int parser_COEX_W = COEX_W;
int parser_COEX_B = COEX_B;
InterruptIn ToggleInt((PinName) COEX_B);

void wifi_pin_CFG(void)
{
#if defined(TARGET_DELTA_DFCM_NNN40) 
 //followings are added by Tsungta	
// nrf_gpio_cfg_output(19);	// SWIO	
// nrf_gpio_cfg_output(18);	//WLAN_Wake
// nrf_gpio_cfg_output(8);	//Chip_En
// nrf_gpio_cfg_output(10);	//Reset_n	
// nrf_gpio_cfg_output(7);	//SPI_SDIO_CFG//Tsungta, 2015/09/22, add for SPI config
 *(uint32_t *)0x50000514 |= 0xC0580;//Tsungta, 2015/10/02, change for cross-platform compiling 
// nrf_gpio_pin_set(19);
// nrf_gpio_pin_set(18);	
// nrf_gpio_pin_set(8);
// nrf_gpio_pin_set(7);	
 *(uint32_t *)0x50000508 = 0xC0180;//Tsungta, 2015/10/02, change for cross-platform compiling  
// nrf_gpio_pin_clear(10);
 *(uint32_t *)0x5000050C = 0x400;//Tsungta, 2015/10/02, change for cross-platform compiling 
 	
 wait_ms(5);//Tsungta, refer to datasheet power-up sequence
// nrf_gpio_pin_set(10);
 *(uint32_t *)0x50000508 = 0x400;//Tsungta, 2015/10/02, change for cross-platform compiling  
#else
 Sleep = 0;//Tsungta, 2015/12/07, make sure to trigger falsh interrupt   
 wait_ms(10);
 Sleep = 1;
 wait_ms(10); 
#endif 
}

extern u8 hif;//Ryan
uint8_t rx_isr = 0;//Ryan
extern struct nmi_wl_adp_t adp;//Ryan
extern u8 bCfgScanning;//Ryan
extern u8 mac_ready;//Ryan
extern u8 scan_done;//Ryan
u8 MacStatus;//Ryan

void notify_Connect_Status(MAC_STATUS_T connect_status) {
	MacStatus = connect_status;
	if (connect_status == MAC_CONNECTED)
	wifi_event = WIFI_CONNECTED;
	else if (connect_status == MAC_DISCONNECTED)
	wifi_event = WIFI_DISCONNECTED;
	DPRINT(N_ERR, "notify_Connect_Status: %d\r\n", connect_status);
}

void check_rx_int(void)
{
   	if (rx_isr)// == 1)
	{
		rx_isr--;//= 0;
//		adp.core.host_indicate_rx_isr();
		adp.core.host_rx_trans();
	}
}

u8 get_rx_int(void)
{
	return rx_isr+2;
}


extern u8 scanned_match_index;
//Serial pc(p25, p23); 
int wifi_core_start(void)
{

  uint8_t i;
  MacStatus = MAC_DISCONNECTED;//Ryan

if (!start_routine) {
	start_routine = true;

#if WIFI_API_DEBUG_LOG	
  //simple_uart_config(RTS_PIN_NUMBER, TX_PIN_NUMBER, CTS_PIN_NUMBER, RX_PIN_NUMBER, HWFC);
  wifi_debug.baud(WIFI_API_DEBUG_BAUDRATE);
#endif

//    pc.baud(115200);
//    pc.printf("INIT...............");	
//	pc.printf("spi_flash_init: %i\n",spi_flash_init());
	spi_flash_init();
	spi_flash_read_security(0x002000, nmi_macaddress, 6);
}  	


	
	wifi_pin_CFG();

  nmc1000_wifi_reset();
  nmc1000_wifi_on();
  
  spi_flash_powerDown();//Tsungta, 2015/09/07, power down SPI flash after wifi init
}

int wait_wifi_event(void)
{
	DPRINT(N_ERR, "wait_wifi_event!!\n");
   while(!wifi_event)
   {
   	if (rx_isr)// == 1)
	{
		rx_isr--;// = 0;
//		adp.core.host_indicate_rx_isr();
		adp.core.host_rx_trans();
		continue;
	}
   	if (hif == 1)
	{
		hif = 0;
		adp.core.host_trans();
		continue;
	}
	//wifi_handle_event
   }	
}

void nmi_os_trace(char *log)
{
#if WIFI_API_DEBUG_LOG	
	//simple_uart_putstring((const uint8_t *)log);
	wifi_debug.printf(log);
#endif	
//	SCI_TraceLow("%s", log);	
}

__weak int wifi_receive_UDP_callback(uint8_t *data, int size, char* ipaddr, int port)
{
  DPRINT(N_ERR, "__weak wifi_receive_UDP_callback: %s %i %s %i \n",data, size, ipaddr, port);
}


__weak int wifi_receive_TCP_callback(uint8_t *data, int size, char* ipaddr, int port) 
{
  DPRINT(N_ERR, "__weak wifi_receive_TCP_callback: %s %i %s %i \n",data, size, ipaddr, port);
}


