/* Copyright (c) 2009 Nordic Semiconductor. All Rights Reserved.
 *
 * The information contained herein is property of Nordic Semiconductor ASA.
 * Terms and conditions of usage are described in detail in NORDIC
 * SEMICONDUCTOR STANDARD SOFTWARE LICENSE AGREEMENT.
 *
 * Licensees are granted free, non-transferable use of the information. NO
 * WARRANTY of ANY KIND is provided. This heading must NOT be removed from
 * the file.
 *
 */

#include "mbed.h"
#include <spi_master.h>

SPI wifi_spi(WIFI_SPI_MOSI, WIFI_SPI_MISO, WIFI_SPI_SCK); // mosi, miso, sclk
DigitalOut wifi_cs(WIFI_SPI_SSN);

uint32_t* spi_master_init()
{
    wifi_cs = 1;
    wifi_spi.format(8,0);
    wifi_spi.frequency(WIFI_SPI_Frequency);

    return 0;
}

bool spi_master_tx_rx(uint8_t module_number, uint16_t transfer_size, const uint8_t *tx_data, uint8_t *rx_data)
{
    uint16_t number_of_txd_bytes = 0;

    if (module_number == 0) 
	wifi_cs = 0;

    while(number_of_txd_bytes < transfer_size)
    {

	    if(tx_data == 0)
	    {

	        rx_data[number_of_txd_bytes] = wifi_spi.write(0x0);;
	    }
		else
			rx_data[number_of_txd_bytes] = wifi_spi.write(tx_data[number_of_txd_bytes]);

        number_of_txd_bytes++;
    };

	if (module_number == 0)
    wifi_cs = 1;

    return true;
}





