////////////////////////////////////////////////////////////////////////////
//
// Copyright (c) Newport Media Inc.  All rights reserved.
//
// Module Name:  nmi_wlan_if.h
//
//
//////////////////////////////////////////////////////////////////////////////

#ifndef NMI_WLAN_IF_H
#define NMI_WLAN_IF_H

#if defined(_LINUX_)

#include <linux/slab.h>
#include <linux/sched.h>
#include <linux/delay.h>
#include <linux/workqueue.h>
#include <linux/interrupt.h>
#include <linux/irq.h>
#include <asm/gpio.h>
#include <linux/kthread.h>
#include <linux/firmware.h>
#include <linux/string.h>
#include <linux/delay.h>

#include <linux/init.h>
#include <linux/netdevice.h>
#include <linux/etherdevice.h>
#include <linux/module.h>
#include <linux/kernel.h>
#include <linux/skbuff.h>
#include <linux/version.h>
#include <linux/semaphore.h>

#else

#define SPI_RW_SEPARATE//Ryan
//#include "os_api.h"
//#include "IN_Message.h"
//#include "tcpip_types.h"
//#include "tcpip_api.h"
//#include "app_tcp_if.h"
//#include "wifisupp_api.h"
#include "nmi_wifi_adapter.h"
//#include "wifi_drv.h"
//#include "nmi_os.h"
//#include "nmi_config.h"//command by Tsungta

#endif

#include "nmi_type.h"

#ifdef __SC6800H__
#define BIG_ENDIAN
#endif

#define SOFT_AP
/********************************************

	Debug Flags

********************************************/

#define N_INIT		0x00000001
#define N_ERR			0x00000002
#define N_TXQ			0x00000004
#define N_INTR 		0x00000008
#define N_RXQ			0x00000010
#define N_TRACE		0x00000020
#define N_LIST		0x00000040
#define N_SCAN		0x00000080
#define N_JOIN		0x00000100
#define N_WARN		0x00000200
#define N_HIF			0x00000400
#define N_BUS			0x00000800
#define N_FW_STATE	0x00001000
#define N_ALL			0xffffffff


/********************************************

	Host SDIO Bus Interface Defines

********************************************/

#define N_SDIO 0
/**
	Note:
		Set the SDIO block size here. The max is 2k.
**/
#define NMI_SDIO_BLOCK_SIZE 			512	

typedef struct {
	u32 read_write:1;
	u32 function:3;
	u32 raw:1;
	u32 address:17;
	u32 data:8;
} sdio_cmd52_t;

typedef struct {
	struct {
		u32 read_write:1;
		u32 function:3;
		u32 block_mode:1;
		u32 increment:1;
		u32 address:17;
		u32 count:9;
	} bit;
	u8 *buffer;
	u32 block_size;
} sdio_cmd53_t;

/********************************************

	Host SPI Bus Interface Defines

********************************************/

//#define SPI_RW_SEPARATE
#define N_SPI 1
#define SPI_DATA_PKT_SZ_256 			256
#define SPI_DATA_PKT_SZ_512				512
#define SPI_DATA_PKT_SZ_1K				1024
#define SPI_DATA_PKT_SZ_2K				(2 * 1024)
#define SPI_DATA_PKT_SZ_4K				(4 * 1024)
#define SPI_DATA_PKT_SZ_8K				(8 * 1024)
/**
	
	Note:
		Set the SPI transfer size here. See above
**/
#define SPI_DATA_PKT_SZ					SPI_DATA_PKT_SZ_4K//SPI_DATA_PKT_SZ_8K	

/********************************************

	Wlan Interfaces Defines 

********************************************/

#define MAX_SSID_LEN            33

typedef enum {
	B_ONLY_MODE = 0,				/* basic rate: 1, 2 Mbps, otherwise: 5, 11 Mbps */
	G_ONLY_MODE,					/* basic rate: 6, 12, 24 Mbps, otherwise: 9, 18, 36, 48, 54 Mbps */
	G_MIXED_11B_1_MODE,		/* basic rate: 1, 2, 5.5, 11 Mbps, otherwise: all on */
	G_MIXED_11B_2_MODE,		/* basic rate: 1, 2, 5, 11, 6, 12, 24 Mbps, otherwise: all on */
} G_OPERATING_MODE_T;

typedef enum {	
	NO_SECURITY = 0,
	WEP_40 = 0x3,
	WEP_104 = 0x7,
	WPA_AES = 0x29,
	WPA_TKIP = 0x49,
	WPA_AES_TKIP = 0x69,		/* Aes or Tkip */
	WPA2_AES = 0x31,
	WPA2_TKIP = 0x51,
	WPA2_AES_TKIP = 0x71,	/* Aes or Tkip */
	WP2_WPA_AES = 0x39,     /* ksong add 2013.5.21 it is a wired value */
	WPA2_WPA_AES_TKIP = 0x79, /* ksong add 2013.5.13 */
} SECURITY_T; 

typedef enum {
	INFRASTRUCTURE  = 1,
	INDEPENDENT     = 2,
	ANY_BSS         = 3
} BSSTYPE_T;

typedef enum{
	PASSIVE_SCAN = 0,
	ACTIVE_SCAN  = 1,
	NUM_SCANTYPE
} SCANTYPE_T;

typedef enum{
	OPEN_SYSTEM = 1,
	SHARED_KEY = 2,
	ANY	= 3
} AUTHTYPE_T;

typedef enum {
	NO_POWERSAVE     = 0,
	MIN_FAST_PS      = 1,
	MAX_FAST_PS      = 2,
	MIN_PSPOLL_PS    = 3,
	MAX_PSPOLL_PS    = 4
} USER_PS_MODE_T;

typedef enum{
	SUCCESS_MLMESTATUS  = 0,
	INVALID_MLMESTATUS  = 1,
	TIMEOUT             = 2,
	REFUSED             = 3,
	TOMANY_REQ          = 4,
	ALREADY_BSS         = 5
} MLMESTATUS_T;

typedef struct {
	int status;
	u8 bssid[6];
	u16 asoc_req_len;	
	u8 *asoc_req;
	u16 asoc_rsp_len;	
	u8 *asoc_rsp;
} nmi_wl_join_rsp_t;

typedef struct {
	int chan_no;
	u8 bssid[6];
	//u16 ssid_len;
	u8 ssid[33];
	BSSTYPE_T bss_type;
	AUTHTYPE_T auth_type;
	SECURITY_T sec_type;
	u8 *key;
	u8 key_len, key_idx;
	u16 beacon_period;
	void *priv;
	void (*join_callback_fun)(void *, nmi_wl_join_rsp_t *);
	void (*disconnect_callback_fun)(void *);
} nmi_wl_join_t;

typedef struct
{
	u32 bss_type;
	u32   chan_no;
	u32  beacon_period;
	u32  cap_info;
	u8  bssid[8];
	u8  ssid[36];
	s32     rssi;
	u32  dot11i_info;
	u32  ht_capable;
	u32 max_rate;
	//u8 *ie;
	//u16 ie_len;
} nmi_wl_bss_t;

typedef struct {
	void *priv;
	SCANTYPE_T scan_type;
	BSSTYPE_T bss_type;
	u32 ssid_len;
	u8 ssid[32];
	u16 n_channel;
	u8 channel[14];
	u32 active_scan_time;
	u32 passive_scan_time;
	unsigned char *ie;
	u32 ie_len;
	void (*scan_callback_fun)(void *, nmi_wl_bss_t *, int, int);
} nmi_wl_scan_t;

typedef struct {
	SECURITY_T sec_type;
	u8 bssid[6];
	u8 key_index;
	int seq_len;
	u8 *seq;
	int key_len;
	u8 *key;
	int grp;

} nmi_add_key_t;

#ifdef SOFT_AP
#define WEP_ENABLED        0x0001
#define TKIP_ENABLED        0x0002
#define AES_ENABLED        0x0004
#define WSEC_SWFLAG        0x0008
#define SHARED_ENABLED  0x00008000
#define WPA_SECURITY    0x00200000
#define WPA2_SECURITY   0x00400000
#define WPS_ENABLED     0x10000000

/**
 * Enumeration of Wi-Fi security modes
 */
typedef enum
{
    SECURITY_OPEN           = 0,                                                /**< Open security                           */
    SECURITY_WEP_PSK        = WEP_ENABLED,                                      /**< WEP Security with open authentication   */
    SECURITY_WEP_SHARED     = ( WEP_ENABLED | SHARED_ENABLED ),                 /**< WEP Security with shared authentication */
    SECURITY_WPA_TKIP_PSK   = ( WPA_SECURITY  | TKIP_ENABLED ),                 /**< WPA Security with TKIP                  */
    SECURITY_WPA_AES_PSK    = ( WPA_SECURITY  | AES_ENABLED ),                  /**< WPA Security with AES                   */
    SECURITY_WPA2_AES_PSK   = ( WPA2_SECURITY | AES_ENABLED ),                  /**< WPA2 Security with AES                  */
    SECURITY_WPA2_TKIP_PSK  = ( WPA2_SECURITY | TKIP_ENABLED ),                 /**< WPA2 Security with TKIP                 */
    SECURITY_WPA2_MIXED_PSK = ( WPA2_SECURITY | AES_ENABLED | TKIP_ENABLED ),   /**< WPA2 Security with AES & TKIP           */

    SECURITY_WPS_OPEN       = WPS_ENABLED,                                      /**< WPS with open security                  */
    SECURITY_WPS_SECURE     = (WPS_ENABLED | AES_ENABLED),                      /**< WPS with AES security                   */

    SECURITY_UNKNOWN        = -1,                                               /**< May be returned by scan function if security is unknown. Do not pass this to the join function! */

    SECURITY_FORCE_32_BIT   = 0x7fffffff                                        /**< Exists only to force security_t type to 32 bits */
} security_t;

typedef struct {
	G_OPERATING_MODE_T g_mode;
	u32   chan_no;
	u8  	bssid[8];
	u8  	ssid[36];
	SECURITY_T sec_type;
	u8 		*key;
	u32 	key_len, key_idx;
	AUTHTYPE_T auth_type;
	u32  	beacon_period;
	u32 	dtim_period;
	int 	enable_11n;
	int 	enable_ba;
	int 	bcst_ssid;	
	u8		*beacon_ie;
	u32 	beacon_ie_len;
} nmi_wl_ap_cfg_t;
#endif

typedef struct {
	u8 password[64];
	u8 ssid[MAX_SSID_LEN];
	u8 psk[40];	
} pmk_cache_info_t;

/********************************************

	Platform Interface Defines

********************************************/

#define HOST_ID_ANDROID 0
#define HOST_ID_RTOS 1

typedef enum {
	TXQ_LOCK = 1,
	RXQ_LOCK,
	CFQ_LOCK,
	QRQ_LOCK,
	QSQ_LOCK,
	IO_LOCK,
#ifdef SOFT_AP
	STA_LOCK,
	PORT_LOCK,
#endif	
} LOCK_ID_T;

typedef enum {
	HIF_WAIT = 1,
	RXQ_WAIT,
	SYNC_WAIT,
} WAIT_ID_T;

typedef struct {
	int type;
	union {
		struct {
			int external_intr_pin;
			int (*sdio_cmd52)(sdio_cmd52_t *);
			int (*sdio_cmd53)(sdio_cmd53_t *);
		} sdio;
		struct {
#ifdef SPI_RW_SEPARATE
			int (*spi_io)(u8 *, u32, u8 *, u32);
#else
			int (*spi_io)(u8 *, u8 *, u32);
#endif
		} spi;
	} u;
} nmi_wl_io_t;

typedef struct {
	void (*print)(char *);
	void (*msleep)(u32);
	void *(*malloc)(u32);
	void (*free)(void *);
	void (*lock)(void *, LOCK_ID_T);
	void (*unlock)(void *, LOCK_ID_T);
	int (*wait)(void *, WAIT_ID_T, u32);
	void (*signal)(void *, WAIT_ID_T);
	u32 (*net_rx)(void *, u8 *, u32);
	void (*net_enable_irq)(void *);
	void (*net_tx_resume)(void *);
	void (*net_tx_stop)(void *);
	void (*net_link_up)(void *);
	void (*net_link_down)(void *);
	void (*power_up)(void *);
	void (*power_down)(void *);
	void (*rssi_fun)(s8); 
#ifdef SOFT_AP
	void (*ap_add_station)(u8 *);
	void (*ap_del_station)(u8 *);
#endif  	 
} nmi_wl_plat_func_t;

typedef struct {
	void *priv;
	u32 dbgflag;	
	u32 host_id;
	nmi_wl_plat_func_t fun;
	nmi_wl_io_t io;
} nmi_wl_platform_t;

typedef void (*free_txb_cb_fun_t)(void *, u8 *, u32);

typedef struct {
//	int (*firmware_download)(u8 *, u32);
	int (*firmware_download)(const u8 *, u32);//Ryan
	int (*hw_start)(void);
	void (*hw_stop)(void);
	void (*host_trans)(void);
	void (*host_indicate_rx_isr)(void);
	void (*host_rx_trans)(void);
	void (*host_tx_trans)(void);
	int (*net_que_tx_frame)(void *, u8 *, u32, free_txb_cb_fun_t);
	void (*net_disp_rx_frame)(void);
	int (*wl_scan)(nmi_wl_scan_t *);
	int (*wl_join)(nmi_wl_join_t *);
	int (*wl_leave)(void);
	int (*wl_add_key)(nmi_add_key_t *);
	int (*wl_del_key)(nmi_add_key_t *);
	int (*wl_get_mac_addr)(void *);
	int (*wl_power_save_enable)(int);
	void (*wl_clean)(void); /* ksong add 2013.5.9 */
	void (*wl_sleep)(u32);	 /* ksong add 2013-6-26 */
	void (*wl_wakeup)(void); /* ksong add 2013-6-26 */
#ifdef SOFT_AP
	int (*wl_cfg_ap)(nmi_wl_ap_cfg_t *);
#endif	
} nmi_wl_core_func_t;

#if 1//Ryan
typedef struct 
{
	void (*router_add_station)(u8 *);
	void (*router_del_station)(u8 *);
	void (*router_receive_from_ap)(u8 *, u32, int *);
} wl_router_api_t;

typedef uint32 TCPIP_NETID_T;//Ryan

struct nmi_wl_adp_t {

#ifdef SOFT_AP
	void *sta_lock;
	void *port_lock;
#endif	
//	void *hif_event;
//	void *rxq_event;
//	void *sync_event;

	nmi_wl_core_func_t core;

	uint8 mac_address[6];

	TCPIP_NETID_T  net_id;

	int quit;

//	uint32 hif_thread_id;
//	uint32 rxq_thread_id ;

	uint8 disconnect_req; /* disconnect request */
	uint8 already_on;	  /*avoid re-enter the init and deinit function. */
	uint8 not_inform_app;  /* sometimes we do not need to inform app that connection is fail */
	NMI_WIFISUPP_SSID_CONFIG_T connect_info; /* Store the connect info */
	NMI_STATE_T state;  /* record the state */
	void *poll_dhcp_timer;	/* dhcp poll timer */
#ifdef SOFT_AP	
	wl_router_api_t wra;
#endif	
};
#endif

extern int nmi_wl_core_init(nmi_wl_platform_t *, nmi_wl_core_func_t *, u8 *);

/* Definitions for error constants. */

#define ERR_OK          0    /* No error, everything OK. */
#define ERR_MEM        -1    /* Out of memory error.     */
#define ERR_BUF        -2    /* Buffer error.            */
#define ERR_TIMEOUT    -3    /* Timeout.                 */
#define ERR_RTE        -4    /* Routing problem.         */
#define ERR_INPROGRESS -5    /* Operation in progress    */
#define ERR_VAL        -6    /* Illegal value.           */
#define ERR_WOULDBLOCK -7    /* Operation would block.   */
#define ERR_USE        -8    /* Address in use.          */
#define ERR_ISCONN     -9    /* Already connected.       */

#define ERR_IS_FATAL(e) ((e) < ERR_ISCONN)

#define ERR_ABRT       -10   /* Connection aborted.      */
#define ERR_RST        -11   /* Connection reset.        */
#define ERR_CLSD       -12   /* Connection closed.       */
#define ERR_CONN       -13   /* Not connected.           */

#define ERR_ARG        -14   /* Illegal argument.        */

#define ERR_IF         -15   /* Low-level netif error    */

#define NMI_PRINTF(...) DPRINT(N_ERR, __VA_ARGS__);//vDebugPrintf("\r\n"); vDebugPrintf(__VA_ARGS__); vDebugPrintf("\r\n");// vTaskDelay( 5 / portTICK_RATE_MS );//printk(__VA_ARGS__)

typedef enum{
	WIFI_SCAN_DONE	= 1,
	WIFI_CONNECTED,
	WIFI_MAC_READY,
	WIFI_DISCONNECTED,//Tsungta		
}tenuWiFiEventType;//Ryan

#endif

