#ifndef NMI_WLAN_H
#define NMI_WLAN_H

#include "nmi_type.h"

/********************************************

	Endian Conversion 

********************************************/

#define BYTE_SWAP(val) ((((val) & 0x000000FF) << 24) + \
                                   		(((val) & 0x0000FF00) << 8)  + \
                                   		(((val) & 0x00FF0000) >> 8)   + \
                                   		(((val) & 0xFF000000) >> 24))


/********************************************

	Macro Defines 

********************************************/
#define SINGLE_TX_QUEUE 
#define HOST_PS
#define STATIC_TX_BUFFER

#ifdef SOFT_AP
#undef HOST_PS
#endif
/********************************************

	Register Defines

********************************************/
#define NMI_PERIPH_REG_BASE 0x1000
#define NMI_CHIPID	(NMI_PERIPH_REG_BASE)
#define NMI_GLB_RESET_0 (NMI_PERIPH_REG_BASE + 0x400)
#define NMI_PIN_MUX_0 (NMI_PERIPH_REG_BASE + 0x408)
#define NMI_MISC	(NMI_PERIPH_REG_BASE+0x428)
#define NMI_INTR_REG_BASE (NMI_PERIPH_REG_BASE+0xa00)
#define NMI_INTR_ENABLE (NMI_INTR_REG_BASE)
#define NMI_INTR_POLARITY (NMI_INTR_REG_BASE+0x10)
#define NMI_INTR_TYPE (NMI_INTR_REG_BASE+0x20)
#define NMI_INTR_CLEAR (NMI_INTR_REG_BASE+0x30)
#define NMI_INTR_STATUS (NMI_INTR_REG_BASE+0x40)

#define NMI_VMM_TBL_SIZE 64
#define NMI_VMM_TX_TBL_BASE (0x150400)
#define NMI_VMM_RX_TBL_BASE (0x150500)

#define NMI_VMM_BASE 0x150000
#define NMI_VMM_CORE_CTL (NMI_VMM_BASE)
#define NMI_VMM_TBL_CTL (NMI_VMM_BASE+0x4)
#define NMI_VMM_TBL_ENTRY (NMI_VMM_BASE+0x8)
#define NMI_VMM_TBL0_SIZE (NMI_VMM_BASE+0xc)
#define NMI_VMM_TO_HOST_SIZE (NMI_VMM_BASE+0x10)
#define NMI_VMM_CORE_CFG (NMI_VMM_BASE+0x14)
#define NMI_VMM_TBL_ACTIVE (NMI_VMM_BASE+040)
#define NMI_VMM_TBL_STATUS (NMI_VMM_BASE+0x44)

#define NMI_SPI_REG_BASE 0xe800
#define NMI_SPI_CTL (NMI_SPI_REG_BASE)
#define NMI_SPI_MASTER_DMA_ADDR (NMI_SPI_REG_BASE+0x4)
#define NMI_SPI_MASTER_DMA_COUNT (NMI_SPI_REG_BASE+0x8)
#define NMI_SPI_SLAVE_DMA_ADDR (NMI_SPI_REG_BASE+0xc)
#define NMI_SPI_SLAVE_DMA_COUNT (NMI_SPI_REG_BASE+0x10)
#define NMI_SPI_TX_MODE (NMI_SPI_REG_BASE+0x20)
#define NMI_SPI_PROTOCOL_CONFIG (NMI_SPI_REG_BASE+0x24)
#define NMI_SPI_INTR_CTL (NMI_SPI_REG_BASE+0x2c)

#define NMI_SPI_PROTOCOL_OFFSET (NMI_SPI_PROTOCOL_CONFIG-NMI_SPI_REG_BASE)

#define NMI_AHB_DATA_MEM_BASE 0x30000
#define NMI_AHB_SHARE_MEM_BASE 0xd0000
#define NMI_AHB_DMA_ADDR (NMI_AHB_DATA_MEM_BASE + 0xe000)

#define NMI_CLR_RX_INTR_REG		(NMI_PERIPH_REG_BASE+0xc8)
#define NMI_TX_SET_INTR_REG		(NMI_PERIPH_REG_BASE+0x78)  /*0xa8*/

#define NMI_SDIO_INTR_TYPE_REG	(NMI_PERIPH_REG_BASE+0x8c)

/********************************************

	FW State Defines

********************************************/

#define FW_TX_OK				0x1
#define FW_SYNC 				0x2
#define FW_SLEEP				0x4
/********************************************

	Size

********************************************/

#define CFG_MSG_HDR_LEN 4
#define N_MAX_TX_SIZE (2*1024)//(8*1024)
#define N_HDR_SIZE 4
#define N_ALIGN_SIZE 4
#define N_GRP_HDR_SIZE 4

/********************************************

	List Helper

********************************************/

struct wl_list {	
	struct wl_list *prev;	
	struct wl_list *next;
};

#define wl_get_list_entry(ptr, type, member) \
	((type *)((char *)(ptr)-(unsigned long)(&((type *)0)->member)))

#define wl_list_for_each(pos, head) \
	for (pos = (head)->next; pos != (head); pos = pos->next)

#define wl_list_for_each_prev(pos, head) \
	for (pos = (head)->prev; pos != (head); pos = pos->prev)

#define wl_list_for_each_safe(pos, n, head) \
	for (pos = (head)->next, n = pos->next; pos != (head); pos = n, n = pos->next)

#if defined(_LINUX_) 
static inline void wl_init_list_head(struct wl_list *list)
{	
	list->next = list;	
	list->prev = list;
}

static inline void wl_list_add(struct wl_list *ne, struct wl_list *prev, struct wl_list *next)
{	
	next->prev = ne;	
	ne->next = next;	
	ne->prev = prev;	
	prev->next = ne;
}

static inline void wl_list_add_head(struct wl_list *ne, struct wl_list *head)
{	
	wl_list_add(ne, head, head->next);
}

static inline void wl_list_add_tail(struct wl_list *ne, struct wl_list *head)
{	
	wl_list_add(ne, head->prev, head);
}

static inline void wl_list_del(struct wl_list *entry)
{	
	struct wl_list *prev = entry->prev;
	struct wl_list *next = entry->next;

	next->prev = prev;	
	prev->next = next;
}

static inline int wl_list_empty(const struct wl_list *head)
{	
	return head->next == head;
}

#else
//static void wl_init_list_head(struct wl_list *list);
//static void wl_list_add(struct wl_list *ne, struct wl_list *prev, struct wl_list *next);
//static void wl_list_add_head(struct wl_list *ne, struct wl_list *head);
//static void wl_list_add_tail(struct wl_list *ne, struct wl_list *head);
//static void wl_list_del(struct wl_list *entry);
//static int wl_list_empty(const struct wl_list *head);

void wl_init_list_head(struct wl_list *list);
void wl_list_add(struct wl_list *ne, struct wl_list *prev, struct wl_list *next);
void wl_list_add_head(struct wl_list *ne, struct wl_list *head);
void wl_list_add_tail(struct wl_list *ne, struct wl_list *head);
void wl_list_del(struct wl_list *entry);
int wl_list_empty(const struct wl_list *head);


#endif
/********************************************

	Mac State Defines

********************************************/

typedef enum {
	MAC_DISCONNECTED = 1, //0,  /* ksong 2013.5.9 */
	MAC_CONNECTED,
	MAC_ALIVE, //MAC_UPDATE_PLL,
	MAC_UPDATE_PLL_DONE,
	MAC_SLEEP,
	MAC_WAKE,
	MAC_READY,
	MAC_TX_DONE,
	MAC_TX_STOP,
} MAC_STATUS_T;

typedef enum {
	MLME_SCAN_RSP   = 0,
	MLME_START_RSP  = 1,
	MLME_JOIN_RSP   = 2,
	MLME_AUTH_RSP   = 3,
	MLME_ASOC_RSP   = 4,
	MLME_UNEXPECT_RSP = 5,  /* ksong 2013-8-9 */
} MLME_RSP_TYPE_T;

/********************************************

	Comamnd Parameters

********************************************/
#if 0
typedef enum {
	B_ONLY_MODE = 0,				/* basic rate: 1, 2 Mbps, otherwise: 5, 11 Mbps */
	G_ONLY_MODE,					/* basic rate: 6, 12, 24 Mbps, otherwise: 9, 18, 36, 48, 54 Mbps */
	G_MIXED_11B_1_MODE,		/* basic rate: 1, 2, 5.5, 11 Mbps, otherwise: all on */
	G_MIXED_11B_2_MODE,		/* basic rate: 1, 2, 5, 11, 6, 12, 24 Mbps, otherwise: all on */
} G_OPERATING_MODE_T;
#endif

typedef enum{
	RATE_AUTO = 0,
	RATE_1MB = 1,
	RATE_2MB = 2,
	RATE_5MB = 5,
	RATE_6MB = 6,
	RATE_9MB = 9,
	RATE_11MB = 11,
	RATE_12MB = 12,
	RATE_18MB = 18,
	RATE_24MB = 24,
	RATE_26MB = 36,
	RATE_48MB = 48,
	RATE_54MB = 54
} TX_RATE_T;

typedef enum {
	G_SHORT_PREAMBLE = 0, 	/* Short Preamble          */
    G_LONG_PREAMBLE  = 1, 		/* Long Preamble           */
    G_AUTO_PREAMBLE  = 2, 		/* Auto Preamble Selection */
} G_PREAMBLE_T;

typedef enum {
	AUTO_PROT = 0,	/* Auto */
	NO_PROT, 			/* Do not use any protection       */
	ERP_PROT, 			/* Protect all ERP frame exchanges */
	HT_PROT,  			/* Protect all HT frame exchanges  */
	GF_PROT,  			/* Protect all GF frame exchanges  */
} N_PROTECTION_MODE_T;

typedef enum {
	SITE_SURVEY_1CH    = 0,
	SITE_SURVEY_ALL_CH = 1,
	SITE_SURVEY_OFF    = 2
} SITE_SURVEY_T;

typedef enum {
	NORMAL_ACK = 0,
    NO_ACK,
} ACK_POLICY_T;

typedef enum {
	G_SELF_CTS_PROT,
    G_RTS_CTS_PROT,
} G_PROTECTION_MODE_T;

typedef enum {
	HT_MIXED_MODE = 1,
	HT_ONLY_20MHZ_MODE,
	HT_ONLY_20_40MHZ_MODE,
} N_OPERATING_MODE_T;

/********************************************

	Command ID Defines

********************************************/

typedef enum {
	WID_CHAR     = 0,
	WID_SHORT    = 1,
	WID_INT      = 2,
	WID_STR      = 3,
	WID_BIN = 4
} WID_TYPE_T;

typedef enum {
WID_NIL                            = -1,

	/* Character WID list */
	WID_BSS_TYPE                       = 0x0000,
	WID_CURRENT_TX_RATE                = 0x0001,
	WID_CURRENT_CHANNEL                = 0x0002,
	WID_PREAMBLE                       = 0x0003,
	WID_11G_OPERATING_MODE             = 0x0004,
	WID_STATUS                         = 0x0005,
	WID_SCAN_TYPE                      = 0x0007,
	WID_PRIVACY_INVOKED                = 0x0008,
	WID_KEY_ID                         = 0x0009,
	WID_QOS_ENABLE                     = 0x000A,
	WID_POWER_MANAGEMENT               = 0x000B,
	WID_11I_MODE                       = 0x000C,
	WID_AUTH_TYPE                      = 0x000D,
	WID_SITE_SURVEY                    = 0x000E,
	WID_LISTEN_INTERVAL                = 0x000F,
	WID_DTIM_PERIOD                    = 0x0010,
	WID_ACK_POLICY                     = 0x0011,
	WID_RESET                          = 0x0012,
	WID_BCAST_SSID                     = 0x0015,
	WID_DISCONNECT                     = 0x0016,
	WID_READ_ADDR_SDRAM                = 0x0017,
	WID_TX_POWER_LEVEL_11A             = 0x0018,
	WID_REKEY_POLICY                   = 0x0019,
	WID_SHORT_SLOT_ALLOWED             = 0x001A,
	WID_PHY_ACTIVE_REG                 = 0x001B,
	WID_TX_POWER_LEVEL_11B             = 0x001D,
	WID_START_SCAN_REQ                 = 0x001E,
	WID_RSSI                           = 0x001F,
	WID_JOIN_REQ                       = 0x0020,
#ifdef MAC_ANTENNA_DIVERSITY_FEATURE
	WID_ANTENNA_SELECTION              = 0x0021,
#endif /* MAC_ANTENNA_DIVERSITY_FEATURE */
	WID_USER_CONTROL_ON_TX_POWER       = 0x0027,
	WID_MEMORY_ACCESS_8BIT             = 0x0029,
	WID_UAPSD_SUPPORT_AP               = 0x002A,
	WID_CURRENT_MAC_STATUS             = 0x0031,
	WID_AUTO_RX_SENSITIVITY            = 0x0032,
	WID_DATAFLOW_CONTROL               = 0x0033,
	WID_SCAN_FILTER                    = 0x0036,
	WID_LINK_LOSS_THRESHOLD            = 0x0037,
	WID_AUTORATE_TYPE                  = 0x0038,
	WID_802_11H_DFS_MODE               = 0x003B,
	WID_802_11H_TPC_MODE               = 0x003C,

	/* Character WID list */
	WID_11N_PROT_MECH                  = 0x0080,
	WID_11N_ERP_PROT_TYPE              = 0x0081,
	WID_11N_ENABLE                     = 0x0082,
	WID_11N_OPERATING_MODE             = 0x0083,
	WID_11N_OBSS_NONHT_DETECTION       = 0x0084,
	WID_11N_HT_PROT_TYPE               = 0x0085,
	WID_11N_RIFS_PROT_ENABLE           = 0x0086,
	WID_11N_SMPS_MODE                  = 0x0087,
	WID_11N_CURRENT_TX_MCS             = 0x0088,
	WID_11N_PRINT_STATS                = 0x0089,
	WID_HUT_FCS_CORRUPT_MODE           = 0x008A,
	WID_HUT_RESTART                    = 0x008B,
	WID_HUT_TX_FORMAT                  = 0x008C,
	WID_11N_SHORT_GI_ENABLE            = 0x008D,
	WID_HUT_BANDWIDTH                  = 0x008E,
	WID_HUT_OP_BAND                    = 0x008F,
	WID_HUT_STBC                       = 0x0090,
	WID_HUT_ESS                        = 0x0091,
	WID_HUT_ANTSET                     = 0x0092,
	WID_HUT_HT_OP_MODE                 = 0x0093,
	WID_RIFS_MODE                      = 0x0094,
	WID_HUT_SMOOTHING_REC              = 0x0095,
	WID_HUT_SOUNDING_PKT               = 0x0096,
	WID_HUT_HT_CODING                  = 0x0097,
	WID_HUT_TEST_DIR                   = 0x0098,
	WID_HUT_PHY_TEST_MODE              = 0x009A,
	WID_HUT_PHY_TEST_RATE_HI           = 0x009B,
	WID_HUT_PHY_TEST_RATE_LO           = 0x009C,
	WID_HUT_DISABLE_RXQ_REPLENISH      = 0x009D,
	WID_HUT_KEY_ORIGIN                 = 0x009E,
	WID_HUT_BCST_PERCENT               = 0x009F,
	WID_HUT_GROUP_CIPHER_TYPE          = 0x00A0,
	WID_TX_ABORT_CONFIG                = 0x00A1,
	WID_HOST_DATA_IF_TYPE              = 0x00A2,
	WID_HOST_CONFIG_IF_TYPE            = 0x00A3,
	WID_HUT_TSF_TEST_MODE              = 0x00A4,
	WID_HUT_PKT_TSSI_VALUE             = 0x00A5,
	WID_REG_TSSI_11B_VALUE             = 0x00A6,
	WID_REG_TSSI_11G_VALUE             = 0x00A7,
	WID_REG_TSSI_11N_VALUE             = 0x00A8,
	WID_TX_CALIBRATION                 = 0x00A9,
	WID_DSCR_TSSI_11B_VALUE            = 0x00AA,
	WID_DSCR_TSSI_11G_VALUE            = 0x00AB,
	WID_DSCR_TSSI_11N_VALUE            = 0x00AC,
	WID_HUT_RSSI_EX                    = 0x00AD,
	WID_HUT_ADJ_RSSI_EX                = 0x00AE,
	WID_11N_IMMEDIATE_BA_ENABLED       = 0x00AF,
	WID_11N_TXOP_PROT_DISABLE          = 0x00B0,
	WID_TX_POWER_LEVEL_11N             = 0x00B1,
	WID_USER_SEC_CHANNEL_OFFSET        = 0x00C0,
	WID_2040_COEXISTENCE               = 0x00C1,
	WID_HUT_FC_TXOP_MOD                = 0x00C2,
	WID_HUT_FC_PROT_TYPE               = 0x00C3,
	WID_HUT_SEC_CCA_ASSERT             = 0x00C4,
	WID_2040_ENABLE                    = 0x00C5,
	WID_2040_CURR_CHANNEL_OFFSET       = 0x00C6,
	WID_2040_40MHZ_INTOLERANT          = 0x00C7,
	WID_HOST_PLATFORM					         = 0x00C8,		/* ykk */
	WID_MLME_RSP					         = 0x00C9,		/* ykk */
	WID_RX_TEST						= 0x00CA,     /* ksong 2013-7-16 */
	WID_DOZE_TIME                          = 0x00CB,	    /* ksong 2013-7-22 */
  /* Character WID list */

  /* Short WID list */
  WID_RTS_THRESHOLD                  = 0x1000,
  WID_FRAG_THRESHOLD                 = 0x1001,
  WID_SHORT_RETRY_LIMIT              = 0x1002,
  WID_LONG_RETRY_LIMIT               = 0x1003,
  WID_BEACON_INTERVAL                = 0x1006,
  WID_MEMORY_ACCESS_16BIT            = 0x1008,
  WID_RX_SENSE                       = 0x100B,
  WID_ACTIVE_SCAN_TIME               = 0x100C,
  WID_PASSIVE_SCAN_TIME              = 0x100D,
  WID_SITE_SURVEY_SCAN_TIME          = 0x100E,
  WID_JOIN_START_TIMEOUT             = 0x100F,
  WID_AUTH_TIMEOUT                   = 0x1010,
  WID_ASOC_TIMEOUT                   = 0x1011,
  WID_11I_PROTOCOL_TIMEOUT           = 0x1012,
  WID_EAPOL_RESPONSE_TIMEOUT         = 0x1013,

  /* Short WID list */
  WID_11N_RF_REG_VAL                 = 0x1080,
  WID_HUT_FRAME_LEN                  = 0x1081,
  WID_HUT_TXOP_LIMIT                 = 0x1082,
  WID_HUT_SIG_QUAL_AVG               = 0x1083,
  WID_HUT_SIG_QUAL_AVG_CNT           = 0x1084,
  WID_11N_SIG_QUAL_VAL               = 0x1085,
  WID_HUT_RSSI_EX_COUNT              = 0x1086,
  WID_CCA_THRESHOLD                  = 0x1087,
  WID_CLK_26M_SETTLE_TIME			= 0x1088,    /* ksong */

  /* Short WID list */

	/* Integer WID list */
	WID_FAILED_COUNT                   = 0x2000,
	WID_RETRY_COUNT                    = 0x2001,
	WID_MULTIPLE_RETRY_COUNT           = 0x2002,
	WID_FRAME_DUPLICATE_COUNT          = 0x2003,
	WID_ACK_FAILURE_COUNT              = 0x2004,
	WID_RECEIVED_FRAGMENT_COUNT        = 0x2005,
	WID_MCAST_RECEIVED_FRAME_COUNT     = 0x2006,
	WID_FCS_ERROR_COUNT                = 0x2007,
	WID_SUCCESS_FRAME_COUNT            = 0x2008,
	WID_HUT_TX_COUNT                   = 0x200A,
	WID_TX_FRAGMENT_COUNT              = 0x200B,
	WID_TX_MULTICAST_FRAME_COUNT       = 0x200C,
	WID_RTS_SUCCESS_COUNT              = 0x200D,
	WID_RTS_FAILURE_COUNT              = 0x200E,
	WID_WEP_UNDECRYPTABLE_COUNT        = 0x200F,
	WID_REKEY_PERIOD                   = 0x2010,
	WID_REKEY_PACKET_COUNT             = 0x2011,
	WID_1X_SERV_ADDR                   = 0x2012,
	WID_STACK_IP_ADDR                  = 0x2013,
	WID_STACK_NETMASK_ADDR             = 0x2014,
	WID_HW_RX_COUNT                    = 0x2015,
	WID_MEMORY_ADDRESS                 = 0x201E,
	WID_MEMORY_ACCESS_32BIT            = 0x201F,
	WID_RF_REG_VAL                     = 0x2021,

	/* Integer WID list */
	WID_11N_PHY_ACTIVE_REG_VAL         = 0x2080,
	WID_HUT_NUM_TX_PKTS                = 0x2081,
	WID_HUT_TX_TIME_TAKEN              = 0x2082,
	WID_HUT_TX_TEST_TIME               = 0x2083,

	/* Integer WID list */
  WID_FW_DEBUG_FLAG               		= 0x2084,

	/* String WID list */
	WID_SSID                           = 0x3000,
	WID_FIRMWARE_VERSION               = 0x3001,
	WID_OPERATIONAL_RATE_SET           = 0x3002,
	WID_BSSID                          = 0x3003,
	WID_WEP_KEY_VALUE                  = 0x3004,
	WID_11I_PSK                        = 0x3008,
	WID_11E_P_ACTION_REQ               = 0x3009,
	WID_1X_KEY                         = 0x300A,
	WID_HARDWARE_VERSION               = 0x300B,
	WID_MAC_ADDR                       = 0x300C,
	WID_HUT_DEST_ADDR                  = 0x300D,
	WID_MISC_TEST_MODES                = 0x300E,
	WID_PHY_VERSION                    = 0x300F,
	WID_SUPP_USERNAME                  = 0x3010,
	WID_SUPP_PASSWORD                  = 0x3011,
	WID_SITE_SURVEY_RESULTS            = 0x3012,	
	WID_RX_POWER_LEVEL                 = 0x3013,
	WID_ADD_WEP_KEY                    = 0x3019,
	WID_REMOVE_WEP_KEY                 = 0x301A,
	WID_ADD_PTK                        = 0x301B,
	WID_ADD_RX_GTK                     = 0x301C,
	WID_ADD_TX_GTK                     = 0x301D,
	WID_REMOVE_KEY                     = 0x301E,
	WID_ASSOC_REQ_INFO                 = 0x301F,
	WID_ASSOC_RES_INFO                 = 0x3020,
	WID_UPDATE_RF_SUPPORTED_INFO       = 0x3021,

  /* String WID list */
  WID_11N_P_ACTION_REQ               = 0x3080,
  WID_HUT_TEST_ID                    = 0x3081,
  WID_PMKID_INFO                     = 0x3082,
  WID_FIRMWARE_INFO                  = 0x3083,
  WID_HOST_SCAN_SSID                  		= 0x3084,

  /* String WID list */
  WID_FIXED_IP_ADDR					 = 0x3090,//Ryan

  /* Binary WID list */
  WID_UAPSD_CONFIG                   = 0x4001,
  WID_UAPSD_STATUS                   = 0x4002,
  WID_WMM_AP_AC_PARAMS               = 0x4003,
  WID_WMM_STA_AC_PARAMS              = 0x4004,
  WID_NETWORK_INFO                   = 0x4005,
  WID_STA_JOIN_INFO                  = 0x4006,
  WID_CONNECTED_STA_LIST             = 0x4007,
	WID_SCAN_BSS_INFO 												= 0x4008,

  /* Binary WID list */
  WID_11N_AUTORATE_TABLE             = 0x4080,
  WID_HUT_TX_PATTERN                 = 0x4081,
  WID_HUT_STATS                      = 0x4082,
  WID_HUT_LOG_STATS                  = 0x4083,

	WID_HOST_PROBE_IE									= 0x4084,
	WID_HOST_SCAN_CHANNEL							= 0x4085,	

 	/* Atmel, 1-15-2015*/ 
  WID_PMK_CACHE_INFO             		= 0x4088, 
 /* Miscellaneous WIDs */
  WID_ALL                            = 0x7FFE,
  WID_MAX                            = 0xFFFF
} WID_T;

/********************************************

	Tx/Rx Queue Structure

********************************************/

#ifdef SINGLE_TX_QUEUE
typedef enum {
	CFG_W = 1,
	CFG_Q,
	NET_D,
} TX_PACKET_ID_T;
#endif

typedef struct que_h {
	int bytes_in_queue;	
	int count;
	LOCK_ID_T lock_id;
	struct wl_list list;
} que_hdr_t;

typedef struct que_e {
	u8 *buffer;	
	u32 buffer_size;	
	struct wl_list list;
} que_e_common_t;

#ifdef SINGLE_TX_QUEUE
typedef struct tx_que_common {
	u8 *buffer;	
	u32 buffer_size;
	struct wl_list list;
	TX_PACKET_ID_T id;
} tx_que_common_t;
#endif

typedef struct txq_e {
	u8 *buffer;	
	u32 buffer_size;
	struct wl_list list;
#ifdef SINGLE_TX_QUEUE
	TX_PACKET_ID_T id;
#endif
	void *priv;
	free_txb_cb_fun_t free_txb_cb;	
} txq_e_t;

typedef struct rxq_e {
	u8 *buffer;	
	u32 buffer_size;	
	struct wl_list list;
} rxq_e_t;

typedef struct set_cfg_e {	
	u8 *buffer;	
	u32 buffer_size;	
	struct wl_list list;
#ifdef SINGLE_TX_QUEUE
	TX_PACKET_ID_T id;
#endif
} cfg_w_e_t;

typedef struct query_cfg_e {
	u8 *buffer;	
	u32 buffer_size;
	struct wl_list list;
#ifdef SINGLE_TX_QUEUE
	TX_PACKET_ID_T id;
#endif
} cfg_q_e_t;

typedef void (*query_cb_fun_t)(u32, u32);

typedef struct query_rsp_e {
	u16 wid;	
	query_cb_fun_t query_cb;
	struct wl_list list;
} cfg_q_rsp_e_t;

typedef struct {
	u8 	type;
	u8 	id;
	u16 	len;
} cfg_msg_hdr_t; 


typedef struct {
	int (*read_reg)(u32, u32 *);
	int (*write_reg)(u32, u32);
	int (*block_rx)(u32, u8 *, u32);
	int (*block_tx)(u32, u8 *, u32);	
	int (*hw_cfg)(void);
	int (*clear_intr)(void);	
} nmi_wl_if_t;

#ifdef __cplusplus
extern "C" {
#endif
extern int nmi_hif_init(nmi_wl_io_t *, nmi_wl_if_t *);
extern void DPRINT(u32, char *fmt, ...);
extern void DPRINT_HEX(u32 grp, char *title, u8 *buf, u32 len);
void set_FW_TX_OK(void);//Tsungta
void get_FW_TX_OK(void);//Tsungta
u32 FW_TX_is_OK(void);

u32 wl_get_chipid(void);
int wl_chip_init(void);
#ifdef __cplusplus
}
#endif

#endif



