#ifndef NMI_ROUTER_H
#define NMI_ROUTER_H

#include "nmi_type.h"
#include "nmi_wlan_if.h"
#include "nmi_wlan.h"

/********************************************

	Debug

********************************************/

#define WRT_ERR 0x1
#define WRT_WARN 0x2
#define WRT_TRACE 0x4


/********************************************

	Defines

********************************************/

#define ROUTER_LOCAL_MASK 0xc0a80100	/* 192.168.1.? */
#define ROUTER_IP_BASE	1
#define ROUTER_PORT_BASE 0xc000		/* ??? */

#define PROT_UDP 17
#define PROT_TCP 6
#define PROT_ICMP 1
#define PROT_IGMP 2

#define ETH_TYPE_IP 0x0800
#define ETH_TYPE_ARP 0x0806
#define ETH_HDR_LEN 14
#define UDP_HDR_LEN 8

#define ARP_HW_TYPE 1
#define ARP_REQUEST	1
#define ARP_REPLY	2
#define ARP_MAC_ADDR_LEN 6
#define ARP_IP_ADDR_LEN 4

#define DHCP_SERVER_PORT 67
#define DHCP_CLIENT_PORT 68
#define DHCP_MAGIC_COOKIE 0x63825363 	/* 0x63, 0x82, 0x53, 0x63 */

/********************************************

	Dhcp Defines

********************************************/

/** DHCP BOOTP CODES **/
#define BOOT_REQUEST	1
#define BOOT_REPLY		2

/** DHCP HTYPE CODE **/
#define HTYPE_ETHER		1
#define HTYPE_IEEE802	6
#define HTYPE_FDDI		8
#define HTYPE_IEEE1394	24

/** DHCP MESSAGE CODES **/
#define DHCP_DISCOVER			1
#define DHCP_OFFER				2
#define DHCP_REQUEST			3
#define DHCP_DECLINE			4
#define DHCP_ACK				5
#define DHCP_NAK				6
#define DHCP_RELEASE			7
#define DHCP_INFORM				8
#define DHCP_FORCE_RENEW		9
#define DHCP_LEASE_QUERY		10
#define DHCP_LEASE_UNASSIGNED	11
#define DHCP_LEASE_UNKNOWN		12
#define DHCP_LEASE_ACTIVE		13

/**	DHCP OPTIONS CODE **/
#define DHO_PAD								0
#define DHO_SUBNET							1
#define DHO_TIME_OFFSET						2
#define DHO_ROUTERS							3
#define DHO_TIME_SERVERS					4
#define DHO_NAME_SERVERS					5
#define DHO_DOMAIN_NAME_SERVERS				6
#define DHO_LOG_SERVER						7
#define DHO_COOKIE_SERVERS					8
#define DHO_LPR_SERVERS						9
#define DHO_IMPRESS_SERVER					10
#define DHO_RESOURCE_LOCATION_SERVERS		11
#define DHO_HOST_NAME						12
#define DHO_BOOT_SIZE                      	13
#define DHO_MERIT_DUMP                     	14
#define DHO_DOMAIN_NAME                    	15
#define DHO_SWAP_SERVER                    	16
#define DHO_ROOT_PATH                      	17
#define DHO_EXTENSIONS_PATH                	18
#define DHO_IP_FORWARDING                  	19
#define DHO_NON_LOCAL_SOURCE_ROUTING       	20
#define DHO_POLICY_FILTER                  	21
#define DHO_MAX_DGRAM_REASSEMBLY           	22
#define DHO_DEFAULT_IP_TTL                 	23
#define DHO_PATH_MTU_AGING_TIMEOUT         	24
#define DHO_PATH_MTU_PLATEAU_TABLE         	25
#define DHO_INTERFACE_MTU                  	26
#define DHO_ALL_SUBNETS_LOCAL              	27
#define DHO_BROADCAST_ADDRESS              	28
#define DHO_PERFORM_MASK_DISCOVERY         	29
#define DHO_MASK_SUPPLIER                  	30
#define DHO_ROUTER_DISCOVERY               	31
#define DHO_ROUTER_SOLICITATION_ADDRESS    	32
#define DHO_STATIC_ROUTES                  	33
#define DHO_TRAILER_ENCAPSULATION          	34
#define DHO_ARP_CACHE_TIMEOUT              	35
#define DHO_IEEE802_3_ENCAPSULATION        	36
#define DHO_DEFAULT_TCP_TTL                	37
#define DHO_TCP_KEEPALIVE_INTERVAL         	38
#define DHO_TCP_KEEPALIVE_GARBAGE          	39
#define DHO_NIS_SERVERS                    	41
#define DHO_NTP_SERVERS                    	42
#define DHO_VENDOR_ENCAPSULATED_OPTIONS    	43
#define DHO_NETBIOS_NAME_SERVERS           	44
#define DHO_NETBIOS_DD_SERVER              	45
#define DHO_NETBIOS_NODE_TYPE              	46
#define DHO_NETBIOS_SCOPE                  	47
#define DHO_FONT_SERVERS                   	48
#define DHO_X_DISPLAY_MANAGER              	49
#define DHO_DHCP_REQUESTED_ADDRESS         	50
#define DHO_DHCP_LEASE_TIME                	51
#define DHO_DHCP_OPTION_OVERLOAD           	52
#define DHO_DHCP_MESSAGE_TYPE              	53
#define DHO_DHCP_SERVER_IDENTIFIER         	54
#define DHO_DHCP_PARAMETER_REQUEST_LIST    	55
#define DHO_DHCP_MESSAGE                   	56
#define DHO_DHCP_MAX_MESSAGE_SIZE          	57
#define DHO_DHCP_RENEWAL_TIME              	58
#define DHO_DHCP_REBINDING_TIME            	59
#define DHO_VENDOR_CLASS_IDENTIFIER        	60
#define DHO_DHCP_CLIENT_IDENTIFIER         	61
#define DHO_NWIP_DOMAIN_NAME               	62
#define DHO_NWIP_SUBOPTIONS                	63
#define DHO_NISPLUS_DOMAIN                 	64
#define DHO_NISPLUS_SERVER                 	65
#define DHO_TFTP_SERVER                    	66
#define DHO_BOOTFILE                       	67
#define DHO_MOBILE_IP_HOME_AGENT           	68
#define DHO_SMTP_SERVER                    	69
#define DHO_POP3_SERVER                    	70
#define DHO_NNTP_SERVER                    	71
#define DHO_WWW_SERVER                     	72
#define DHO_FINGER_SERVER                  	73
#define DHO_IRC_SERVER                     	74
#define DHO_STREETTALK_SERVER              	75
#define DHO_STDA_SERVER                    	76
#define DHO_USER_CLASS                     	77
#define DHO_FQDN                           	81
#define DHO_DHCP_AGENT_OPTIONS             	82
#define DHO_NDS_SERVERS                    	85
#define DHO_NDS_TREE_NAME                  	86
#define DHO_NDS_CONTEXT					   	87
#define DHO_CLIENT_LAST_TRANSACTION_TIME   	91
#define DHO_ASSOCIATED_IP				   	92
#define DHO_USER_AUTHENTICATION_PROTOCOL   	98
#define DHO_AUTO_CONFIGURE                	116
#define DHO_NAME_SERVICE_SEARCH           	117
#define DHO_SUBNET_SELECTION              	118
#define DHO_DOMAIN_SEARCH	              	119
#define DHO_CLASSLESS_ROUTE				  	121
#define DHO_END                            	-1 

/** DHCP PACKET LENGTH **/
#define BOOTP_ABSOLUTE_MIN_LEN	236
#define DHCP_VEND_SIZE		64
#define DHCP_MAX_MTU		1500


/********************************************

	Net Header

********************************************/

typedef struct 
{
	u8 eth_dst[6];
	u8 eth_src[6];
	u16 eth_type;

} eth_hdr_t;

typedef struct {
 	u8 ip_hl:4;
	u8 ip_v:4; /* this means that each member is 4 bits */
 	u8 ip_tos;
 	u16 ip_len;
 	u16 ip_id;
 	u16 ip_off;
 	u8 	ip_ttl;
 	u8 	ip_p;
 	u16 ip_sum;
 	u32 ip_src;
 	u32 ip_dst;
} ip_hdr_t; 

typedef struct {
 	u16 	th_sport;
 	u16 	th_dport;
 	u32 	th_seq;
 	u32 	th_ack;
 	u8 		th_x2:4, th_off:4;
 	u8 		th_flags;
 	u16 	th_win;
 	u16 	th_sum;
 	u16 	th_urp;
} tcp_hdr_t; 

typedef struct {
 	u16 	uh_sport;
 	u16 	uh_dport;
 	u16 	uh_len;
 	u16		uh_check;
} udp_hdr_t; 

typedef struct 
{
	u8	op;
	u8 	htype;
	u8	hlen;
	u8	hops;
	u8	xid[4];
	u8	secs[2];
	u8	flags[2];
	u8	ciaddr[4];
	u8	yiaddr[4];
	u8	siaddr[4];
	u8	giaddr[4];
	u8	chaddr[16];
	u8	sname[64];
	u8	file[128];
	u8 	magic[4];
}	dhcp_hdr_t;

typedef struct 
{
	u8 type;
	u8 code;
	u16 checksum;
} icmp_hdr_t;

typedef struct
{
	u16 identifier;
	u16 seq;
} icmp_echo_t;

typedef struct
{
	u16 sport;
	u16 dport;
} icmp_port_t;


typedef struct {
	u16 hw_type;           	// Hardware type
  u16 pro_type;           // Protocol type
	u8 hw_adr_len;					// hardware address length
	u8 pro_adr_len;					// Protocol address length
	u16 opcode;							// 
} arp_hdr_t;

/********************************************

	Macro

********************************************/

#if 1//0
#define htons(x) (((x & 0xff) << 8) | ((x & 0xff00) >> 8))
#define ntohs(x) htons(x)
#define htonl(x) (((x & 0xff) << 24) | ((x & 0xff00) << 8) | ((x & 0xff0000UL) >> 8) | ((x & 0xff000000UL) >> 24))
#define ntohl(x) htonl(x)
#endif

/********************************************

	Router Data Structure

********************************************/

typedef struct
{
	void (*print)(u8 *);
	void (*msleep)(u32);
	void (*lock)(void *, LOCK_ID_T);
	void (*unlock)(void *, LOCK_ID_T);
	void *(*malloc)(u32);
	void (*free)(void *);
	void (*memset)(void *, int, u32);
	void (*memcpy)(void *, const void *, u32);
 	int (*memcmp)(void *, void *, u32);
	void (*router_send_to_ap)(u8 *, u32);
} wl_router_plat_fun_t;

typedef struct 
{
	void *priv;
	u32 dbgflag;
	u8 local_mac_adr[6];
	u8 pad[2];	
	wl_router_plat_fun_t fun;
} wl_router_plat_t;
#if 0
typedef struct 
{
	void (*router_add_station)(u8 *);
	void (*router_del_station)(u8 *);
	void (*router_receive_from_ap)(u8 *, u32, int *);
} wl_router_api_t;
#endif
typedef struct {
	int count;
	struct wl_list list;
} sta_head_t;

typedef struct {
	u32 slot;						/* station slot ??? */
	sta_head_t sa_h;		/* station list head */

	wl_router_plat_t plat;
} wl_router_t;

typedef struct {
	u16 sport;		/* source port */
	u16 mport;		/* map port */
		
	struct wl_list list;
} port_map_t ;

typedef struct {
	int count;
	int lock_id;
	struct wl_list list;
} port_map_head_t;

typedef struct {
	wl_router_t *wrt;

	u8 mac_address[6];	/* station mac address */
	u8 ip_address[4];		/* station ip address */

	u16 port_base;
	u16 port_cur;
	port_map_head_t pm_h;

	struct wl_list list;
} sta_t;


/********************************************

	Global Function

********************************************/

extern int wrt_core_init(wl_router_plat_t *, wl_router_api_t *);

#endif



