
#include <spi_flash.h>

#include "spi_master.h"

#include "wait_api.h"
#include "mbed.h"
DigitalOut flash_cs(WIFI_BOOT);

#if 1	//marcus add for flash read/write
#define MFG_ID_WINBOND (0xEF)
#define DEVICE_ID_WINBOND_8M (0x6014)//Tsungta, updated for W25Q80EW

#define CMD_POWER_UP (0xAB)
#define CMD_JEDEC_ID	(0x9F)
#define CMD_POWER_DOWN	(0xB9)
#define CMD_READ_STATUS	(0x05)
#define CMD_WRITE_ENABLE (0x06)
#define CMD_PAGE_PROG (0x02)
#define CMD_READ_DATA (0x03)
#define CMD_ERASE_4K (0x20)
#define CMD_ERASE_64K (0xD8)
#define CMD_DUMMY	(0xFF)

// added by Tsungta
#define CMD_READ_UNIQUE_ID (0x4B)
#define CMD_ERASE_SECU (0x44)
#define CMD_PAGE_PROG_SECU (0x42)
#define CMD_READ_SECU (0x48)

#define	THREE_BYTE_LENGTH	3
#define WIFIDRI_LENGTH (136568)
#define ERASEWIFI_LENGTH (2696)
#define DEVICE_PAGE_SIZE (256)
#define DEVICE_SECTOR_SIZE (4096)
#define DEVICE_BLOCK_SIZE (65536)
#ifdef WIFI_BOOT_NORDIC
extern const unsigned char wifi_firmware[];
#endif
#endif

#if 1	//marcus add for flash read/write
static bool spi_flash_writeOneByte(uint32_t *spi_base_address, uint8_t DataBuffer)
{
		spi_master_tx_rx(1, 1, &DataBuffer, 0);
		return true;
}

static uint8_t spi_flash_readOneByte(uint32_t *spi_base_address)
{
		uint8_t DataBuffer;
		spi_master_tx_rx(1, 1, 0, &DataBuffer);	
	
		return DataBuffer;
}

bool spi_flash_init(void)
{
		uint8_t mfgId;
		uint16_t deviceID;
	
    uint32_t * p_spi_base_address = 0;
    
    flash_cs = 1;
    wait_ms(10);	//Tsungta, 2015/12/07, make sure to wakeup falsh from sleep    
    flash_cs = 0;
    wait_ms(10);	//Tsungta, 2015/12/07, make sure to wakeup falsh from sleep
    spi_flash_writeOneByte(p_spi_base_address, CMD_POWER_UP);

	flash_cs = 1;
	wait_us(100);		
		//wait for wake up
		wait_us(30);

		flash_cs = 0;
		wait_us(100);	
		spi_flash_writeOneByte(p_spi_base_address, CMD_JEDEC_ID);
		
		mfgId = spi_flash_readOneByte(p_spi_base_address);
		deviceID = (uint16_t)(spi_flash_readOneByte(p_spi_base_address) << 8);
		deviceID |= spi_flash_readOneByte(p_spi_base_address);

		flash_cs = 1;
		wait_us(100);	
		if (mfgId != MFG_ID_WINBOND || deviceID != DEVICE_ID_WINBOND_8M) {
				return false;
		}
		
		return true;
}

bool spi_flash_powerDown(void)
{			
    uint32_t * p_spi_base_address = 0;
    
    flash_cs = 0;
    wait_us(100);	
    spi_flash_writeOneByte(p_spi_base_address, CMD_POWER_DOWN);

	flash_cs = 1;
	wait_us(100);		
		//wait for sleep
		wait_us(3);
		
		return true;
}

bool spi_flash_waitBusy(void)
{
		uint8_t status;
    uint32_t * p_spi_base_address = 0;
    
    flash_cs = 0;
    wait_us(100);	
    spi_flash_writeOneByte(p_spi_base_address, CMD_READ_STATUS);
		status = spi_flash_readOneByte(p_spi_base_address);

	flash_cs = 1;
	wait_us(100);		
		if ( (status & 0x01) == 0x01 )
		{
				return true;
		} else {
				return false;
		}
}

void spi_flash_setWEL(void)
{
    uint32_t * p_spi_base_address = 0;
    
    flash_cs = 0;
    wait_us(100);	
    spi_flash_writeOneByte(p_spi_base_address, CMD_WRITE_ENABLE);

    flash_cs = 1;
    wait_us(100);	
}

void spi_flash_writePage(uint32_t address, uint8_t *data, uint16_t len)
{
		//wait busy
		while(spi_flash_waitBusy()) {};
		
		//setWEL
		spi_flash_setWEL();

    uint32_t * p_spi_base_address = 0;
    
		flash_cs = 0;
		wait_us(100);	
    spi_flash_writeOneByte(p_spi_base_address, CMD_PAGE_PROG);
		
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 16) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 8) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, (address & 0xFF));
		
		/* write data */
		while(len--) {
			spi_flash_writeOneByte(p_spi_base_address, *data++);
		}			

	flash_cs = 1;
	wait_us(100);		
		return;
}

void spi_flash_eraseCmd(uint8_t command, uint32_t address)
{
    uint32_t * p_spi_base_address = 0;

		//wait busy
		//while(spi_flash_waitBusy()) {};//Tsungta, 2016/01/13, remove this line for platform other than NNN40

		//setWEL
		spi_flash_setWEL();	
			
	flash_cs = 0;
	wait_us(100);		
    spi_flash_writeOneByte(p_spi_base_address, command);
		
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 16) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 8) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, (address & 0xFF));

		flash_cs = 1;
		wait_us(100);	
}

void spi_flash_erase(void)
{
		uint32_t address = 0;
		uint32_t totalLength = WIFIDRI_LENGTH + ERASEWIFI_LENGTH;	//To map SECTOR size

		//wait busy
		while(spi_flash_waitBusy()) {};

		//setWEL
		spi_flash_setWEL();			

		// handle any full blocks
		while(totalLength >= DEVICE_BLOCK_SIZE) {
			spi_flash_eraseCmd(CMD_ERASE_64K, address);
			address += DEVICE_BLOCK_SIZE;
			totalLength -= DEVICE_BLOCK_SIZE;
		}	

		// finally handle any trailing partial blocks
		while(totalLength) {
			spi_flash_eraseCmd(CMD_ERASE_4K, address);
			address += DEVICE_SECTOR_SIZE;
			totalLength -= DEVICE_SECTOR_SIZE;
		}

		return;
}

void spi_flash_readpage(uint32_t address, uint8_t *data, uint16_t len)
{

		uint16_t i = 0;	
	
		//wait busy
		while(spi_flash_waitBusy()) {};
			
    uint32_t * p_spi_base_address = 0;

	flash_cs = 0;
	wait_us(100);		
    spi_flash_writeOneByte(p_spi_base_address, CMD_READ_DATA);
		
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 16) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 8) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, (address & 0xFF));
		
		/* read data */
		
		for (i=0; i < len; i++){	
				*data++ = spi_flash_readOneByte(p_spi_base_address);
		}		
	
    flash_cs = 1;
    wait_us(100);	
}
	#ifdef WIFI_BOOT_NORDIC
void spi_flash_write(void)
{
	uint32_t totalLength = WIFIDRI_LENGTH;
	uint32_t address = 0;
	uint16_t len = DEVICE_PAGE_SIZE;

	uint8_t *data = wifi_firmware;


  while(totalLength) {
    spi_flash_writePage(address, data, len);
    totalLength -= len;
    address += len;
    data += len;
    len = (totalLength>DEVICE_PAGE_SIZE)? DEVICE_PAGE_SIZE : totalLength;
  }	
}
#endif
#endif

void spi_flash_read_uniqueID(uint8_t *data)
{
		uint8_t dummy_len = 4;
		uint8_t id_len = 8;
		//wait busy
		while(spi_flash_waitBusy()) {};
			
    uint32_t * p_spi_base_address = 0;

	flash_cs = 0;
	wait_us(100);		
    spi_flash_writeOneByte(p_spi_base_address, CMD_READ_UNIQUE_ID);
		while(dummy_len--)
			spi_flash_readOneByte(p_spi_base_address);		// there is four dummy bytes before real data
		/* id data */
		while(id_len--) 
			*data++ = spi_flash_readOneByte(p_spi_base_address);			

    flash_cs = 1;
    wait_us(100);	
}

void spi_flash_read_security(uint32_t address, uint8_t *data, uint16_t len)
{

#ifdef FLASHDEBUG
		uint8_t data = 0;
		uint8_t i = 1;	
#endif
	
		//wait busy
		while(spi_flash_waitBusy()) {};

			
    uint32_t * p_spi_base_address = 0;
    
	flash_cs = 0;
	wait_us(100);		
    spi_flash_writeOneByte(p_spi_base_address, CMD_READ_SECU);
		
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 16) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, ((address >> 8) & 0xFF));
		spi_flash_writeOneByte(p_spi_base_address, (address & 0xFF));
		
		spi_flash_readOneByte(p_spi_base_address);		// there is a dummy byte before real data
		/* read data */
		while(len--) {

			*data++ = spi_flash_readOneByte(p_spi_base_address);
		
		}

    flash_cs = 1;
    wait_us(100);	
}



