#include "mbed.h"
#include "Gap.h"
#include "command-interpreter.h"  
#include "nrf_gpio.h"

#define UART_2ND_TX p16
#define UART_2ND_RX p17
#define UART_2ND_TX_PIN 16
#define UART_2ND_RX_PIN 17
DigitalOut swio(p19);
Serial console(TX_PIN_NUMBER,RX_PIN_NUMBER);

int main(void)
{
    
    /* Removing Select external 32MHz crystal for NNN40-DT1R */ 
    uint8_t inputChar;
    nrf_gpio_cfg_output(7);
    nrf_gpio_pin_set(7);
    // gill 20150914 Re-configure UART pin by UART_2ND_CFG_PIN   
    //nrf_gpio_cfg_input(UART_2ND_TX_PIN, NRF_GPIO_PIN_NOPULL);
    nrf_gpio_cfg_input(UART_2ND_RX_PIN, NRF_GPIO_PIN_PULLDOWN);
    wait(0.5);
    //console.printf("UART RX 2ND READ %i\r\n",nrf_gpio_pin_read(UART_2ND_RX_PIN));
    if (nrf_gpio_pin_read(UART_2ND_RX_PIN))
    {
        Serial console(UART_2ND_TX,UART_2ND_RX);
        //console.baud(115200);
        //console.printf("UART RX 2ND READ %i\r\n",nrf_gpio_pin_read(UART_2ND_RX_PIN));
    }
    else
    {
        
    }
    console.baud(115200);
    
    /* swio default low for BLE RF */
    swio = 0;
    console.printf("\r\nDELTA BLE with WiFi\r\n");
    while(1) {
        while (NRF_UART0->EVENTS_RXDRDY != 1)
        {
            // Wait for RXD data to be received
        }
        NRF_UART0->EVENTS_RXDRDY = 0;
        inputChar = (uint8_t)NRF_UART0->RXD;  
        //char input = inputChar;
//        console.printf(&input);

        cyntecProcessCommandInput(inputChar);
    }
}
//test