/** @file command-interpreter.h
* @brief Processes commands coming from the serial port.
* See @ref commands for documentation.
*
* Copyright 2014 by DELTA Corporation.  All rights reserved.
*/

#ifndef COMMAND_INTERPRETER_H
#define COMMAND_INTERPRETER_H

#include <stdbool.h>
#include <stdint.h>
#include "mbed.h"
//#inlcude "nordic/boards.h"

#define DELTA_BLE_ON 1
#define DELTA_WIFI_ON 1
#define SIMPLE_CMD_NAME 0

#ifndef CYNTEC_COMMAND_BUFFER_LENGTH
#define CYNTEC_COMMAND_BUFFER_LENGTH 255
#endif

#ifndef MAX_TOKEN_COUNT
#define MAX_TOKEN_COUNT 16
#endif

#ifdef __cplusplus
extern "C" {
#endif 

enum {
  CYNTEC_CMD_SUCCESS,                 
  CYNTEC_CMD_ERR_NO_SUCH_COMMAND,
	CYNTEC_CMD_ERR_WRONG_NUMBER_OF_ARGUMENTS,
  CYNTEC_CMD_ERR_ARGUMENT_OUT_OF_RANGE,        
  CYNTEC_CMD_ERR_ARGUMENT_SYNTAX_ERROR,	
  CYNTEC_CMD_ERR_NO_MATCHED_ARGUMENT,
	CYNTEC_CMD_ERR_WRONG_CMD_ORDER,
	CYNTEC_CMD_ERR_INVALID_STATE_TO_PERFORM_OPERATION,
  CYNTEC_CMD_ERR_CALL_FAIL
};

typedef void (*CommandAction)(void);

typedef const struct {
  /** Use letters, digits, and underscores, '_', for the command name.
   * Command names are case-sensitive.
   */
  const char *name;
  /** A reference to a function in the application that implements the 
   *  command.
   *  If this entry refers to a nested command, then action field
   *  has to be set to NULL.
   */
  CommandAction action;
	/*
   *  In case of a nested command (action is NULL), then this field
   *  contains a pointer to the nested CyntecCommandEntry array.
	 */
	const char *subMenu;
  /** A description of the command.
   */
  const char *description;
} CyntecCommandEntry;

extern CyntecCommandEntry cyntecCommandTable[];

uint8_t cyntecAtoi(uint8_t *str, uint8_t len);
int cyntecAtoInt(uint8_t *str, uint8_t len);
uint8_t cyntecArgToUint8(uint8_t *str, uint8_t len);
uint16_t cyntecAtoiUint16(uint8_t *str, uint8_t len);
uint16_t cyntecArgToUint16(uint8_t *str, uint8_t len);
uint32_t cyntecHexToUint32(uint8_t *str, uint8_t len);
uint8_t cyntecStrCmp(uint8_t *src, uint8_t *dst, uint8_t len);

/**
 * @brief Process the given char as a command.
 **/
void cyntecProcessCommandInput(uint8_t input);

/** @brief Initialize the command interpreter.
 */
void cyntecCommandReaderInit(void);

/** Retrieves unsigned integer arguments. */
uint8_t *cyntecGetCommandArgument(uint8_t argNum, uint8_t *length);
uint8_t *cyntecGetMinusArgument(uint8_t argNum, uint8_t *length);
extern void clearBuffer(void);

/** Retrieves the token count. */
uint8_t cyntecGetCommandTokenCnt(void);

//gill add for accept blank in name 20150904
//uint8_t *cyntecGetCommandBuffer(void);
uint8_t *cyntecGetCommandTotalBuffer(void);
void cyntecWriteToTotalBuffer(uint8_t input);
uint8_t cyntecGetTotalIndex(void);
uint8_t isValidGPIO(uint8_t);

#ifdef __cplusplus
}
#endif
#endif


