#include "mbed.h"
#include "math.h"

// copyright gilisymo www.gilisymo.com
//This program has been demonstrated at Grenoble makerfaire 2017 by the gilisymo team

//This program reads the PWM output of the LS53L0X laser distance sensor from Gilisymo using an STMicroelectronics nucleo F401 board
//it controls a servo from hobby king (HK15178 https://hobbyking.com/fr_fr/hobbykingtm-hk15178-analog-servo-1-4kg-0-09sec-10g.html)
//the measured distance is send to UART, for interface with HC06 bluetooth serial SPP controler 

//Developer: Sylvain TRIVIAUX

PwmOut mypwm(PA_8);
PwmOut servo(PB_8);
Serial myUART(PA_9, PA_10);
DigitalOut myled(LED1);
DigitalIn myIOs(PA_0);
InterruptIn EWOK_INTR(PA_0);



Serial device(PA_2,PA_3);

Ticker clockServo;
Ticker clockDistance;

int counter;
int counterDist = 0;

int incrPWM =10;
//int pw_def = 500;
int pw_def ;
int pw = 100;
int increase=1; 

float TICK_FREQ_SERVO = 0.01; // 10ms
float TICK_FREQ_DIST = 0.0001; //0.1us

//CONFIG SERVO
int SERVO_MAX = 2500;
int SERVO_MIN = 500;

int SERVO_PERIOD_MS = 10;
int SERVO_PW_DEF_US = 500;


int UART_BAUDS_DEF = 9600;

int angle_servo = 0;
int direction = 0;

void initServo(PwmOut* servo, int servo_period_ms, int pw_def_us)
{
    printf("\t\tSERVO INITIALIZATION START\n");
    servo->period_ms(servo_period_ms);   
    servo->pulsewidth_us(pw_def_us); //butee droite
    //pw = pw_def_us;
    printf("\t\tSERVO INITIALIZATION DONE\n");
}

void positionServo(PwmOut* servo, int angle_deg)
{
    int pw_angle;
    float ratio = (SERVO_MAX - SERVO_MIN)/180;
    pw_angle = (int) (angle_deg*ratio+SERVO_MIN);
    servo->pulsewidth_us( pw_angle);
}

//Interruption

void clockServo_int()
{
int angle;

 switch (direction)
 {
     case 0:
     {
        //printf("case 0\n;");
         if(angle_servo >180)
         {
            direction = 1;   
            angle_servo= angle_servo -1;         
             break;
         }
         
         if(angle_servo < 0)
         {
            direction = 0; 
            angle_servo= angle_servo +1;
             break;
         }
         angle_servo= angle_servo +1;
         break;
     }
     
     case 1:
     {
         
         //printf("case 1\n;");
         if(angle_servo >=180)
         {
            direction = 1; 
            angle_servo= angle_servo -1;
             break;
         }
         
         if(angle_servo <= 0)
         {
            direction = 0; 
            angle_servo= angle_servo +1;
             break;
         }
         angle_servo = angle_servo -1;
         break;
     }
     
      
     
 }
   //printf("angle_servo %i\n", angle_servo);
   positionServo(&servo, angle_servo);
         
}//void clock10ms_int


void clockDist_int()
{
  counterDist = counterDist +1;    
}


char* PACKET_START= "PACKET_START";
char* PACKET_END= "PACKET_END";

char* SERVO_POS_START= "SERVO_POS_START";
char* SERVO_POS_END= "SERVO_POS_END";



time_t interuptionTime = time(NULL);

  time_t interUp ;
    time_t interDown;
    int duration ;
    Timer EWOK;
   
    
    
void EWOK_UP()
{
    EWOK.start();
    interUp =   time(&interuptionTime);
}

void EWOK_DOWN()
{
    EWOK.stop();
    duration =EWOK.read_us();
    EWOK.reset();   
    printf("duration %i\n", duration);

}



int main() {
    printf("\n\n\n##### Nucleo RADAR ######\n");
    printf("\n\nRadar Initialization\n");
    
    myled = 0; 
    counter = 0;
    pw_def = SERVO_PW_DEF_US;
    pw = SERVO_PW_DEF_US;
    myUART.baud(UART_BAUDS_DEF);   
    clockServo.attach(&clockServo_int, TICK_FREQ_SERVO);        
   
    mypwm.period_ms(10);
    mypwm.pulsewidth_ms(1);
    initServo(&servo, SERVO_PERIOD_MS, SERVO_PW_DEF_US); 
    printf("\nRadar Initialization done\n");      
    int angle =0;
    EWOK.reset();
    EWOK.stop();
    EWOK_INTR.rise(&EWOK_UP);
    EWOK_INTR.fall(&EWOK_DOWN);
     
    while(1){         
    
      //manual command of servo through terminal      
      printf("Use following keys\n");
      printf("\tEnter to start Radar\n");
      printf("\tt: to center the Radar\n");
      printf("\ty to set it to the right\n");
      printf("\tr to set it to the left\n");
      
      /*
      char c = device.getc();
      if(c == 'r') { //r-> left
                servo.pulsewidth_us(2500);
      }
      if(c == 'y') { //y-> right
                servo.pulsewidth_us(500);
      }
      
      if(c == 't') { //t-> center
                servo.pulsewidth_us(1500);
      }
      
      if(c == '\r') { //enter = launching radar
      */
               
               printf("Enter pressed, starting radar\n");
               while(1)
               {
                //printf("%i:%i\n", angle_servo, duration);
                myUART.printf("%i:%i\n", angle_servo, duration);
               }
               
      /*
             if(c == 'r') { //r-> left
                manualServo = 0;
                manualServo = 1;
                wait_us(2500);
                manualServo = 0;
                wait_us(1);
             }
             
             if(c == 't') {  // t-> right
                manualServo = 0;
                manualServo = 1;
                wait_us(500);
                manualServo = 0;
                wait_us(1);
             }
             
             if(c == 'y') { 
                manualServo = 0;
                //wait_us(10);
                manualServo = 1;
                wait_us(1500);
                manualServo = 0;
                wait_us(1);
                //wait_us(49500)  ;              
             }
        */        
        }
}//main
