#include "mbed.h"
#define maske 0b1111


BusOut leds(D12, D11, D10, D9);
InterruptIn btn1(A0);
InterruptIn btn2(A1);
AnalogIn Poti(A2);
float messen;  //Auslesen des Potiwertes
float aktuellerwert = 0; //Der Aktuelle Wert des Timers
Ticker t;

void starte();
void timerstart();
void wechsle();

struct pos{  //anlegen der Bits
    uint8_t a:1;
    uint8_t b:1;
    uint8_t c:1;
    uint8_t d:1;
   };

union ausg{ 
    uint8_t komplett; //fürs anzeigen der kompletten bits
    struct pos position; 
    }ausgabe;

int main() {
    btn1.rise(starte); // es leuchten 2 leds
    btn2.rise(timerstart); // der timer wird gestartet und erhält den aktuellen 
    //Wert des Potis, die Leds werden in regelmäßigen Zeitabständen
    //von 0 - 2 Sekunden invertiert, je nach Wert des Potis
    
    
    while(1) {
      messen = Poti.read();  //Der Wert des Potis wird übergeben
    }
}

void starte()
    {
      t.detach(); //Timer wird beendet
    ausgabe.position.a = 1; //bit 1 wird auf 1 gesetzt
    ausgabe.position.b = 1; //bit 2 wird auf 2 gesetzt   
    leds = ausgabe.komplett; //bits werden ausgegeben 0b0011
        }
        
         void timerstart()
    {
      aktuellerwert = messen*2; //Potiwert wird * 2 gerechnet
      t.attach((wechsle), aktuellerwert); //Timer wird mit dem Wert des Potis
      //gestartet
      
    }
    
    void wechsle()
        {
            ausgabe.komplett ^= maske; // Leds werden getoggelt
            leds = ausgabe.komplett; // Leds werden ausgegeben
            }