
#include "FuncGenFSST.h"

//SignalRampGen
SignedRampGen::SignedRampGen()
{
    val=0;
    SetPointsPerPeriod(20);
}

void SignedRampGen::SetPointsPerPeriod(float aPoints)
{
  _inc = 2.0/aPoints;
}

void SignedRampGen::SetFrequ(float aFrequ)
{
  SetPointsPerPeriod(1.0/aFrequ);
}

void SignedRampGen::CalcOneStep()
{
  val = val + _inc;
  if( val>1.0 )
  val = -1 + (val - 1.0); 
}
//----------------------------------------------------------------------------------
//TriangleRampGen
TriangleGen::TriangleGen()
{
    val = 0;
    int _state = 1;
    float _phase = 0.0f;
    SetPointsPerPeriod(20);
}

void TriangleGen::SetPointsPerPeriod(float aPoints)
{
    _inc = 4.0/aPoints;
}

void TriangleGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ); 
}    

void TriangleGen::CalcOneStep()
{
    _phase = _phase + _inc;
    if( _phase>1.0 )
    {
    _phase = -1 + (_phase - 1.0);
    if(_state == 1)
    _state = 2;
    else
    _state = 1;
    }
    
    if(_state == 1)
    val = _phase;
    else if(_state == 2)
    val = -_phase;
}


//------------------------------------------------------------------------------
//Rect
RectGen::RectGen()
{
   val = 0; 
   SetPointsPerPeriod(20);
   _phase = 0.0f;
   _thrs = 0.0f;
}
void RectGen::SetPointsPerPeriod(float aPoints)
{
  _inc = 2.0/aPoints;
}

void RectGen::SetFrequ(float aFrequ)
{
    SetPointsPerPeriod(1.0/aFrequ);
}

void RectGen::SetPulsWidth(float aPercent)
{  
 _thrs=aPercent; // möglicherweise andere Formel
}
void RectGen::CalcOneStep()
{
  //Erzeugen des SignalRampGen
  _phase = _phase + _inc;
  if( _phase>1.0 )
  _phase = -1 + (_phase - 1.0); 
   
  //Erzeugen des PWMs
  if( _phase < _thrs)
  val = -1;
  else
  val = +1;
}

//------------------------------------------------------------------------------