#include "mbed.h"
 
BusOut myleds(D9, D10, D11, D12);
 
void print_binary(uint8_t x) {  // function to print binary   
    for(int i=sizeof(x)<<3; i; i--)
        putchar('0'+((x>>(i-1))&1));
}


 
int main() {
    uint8_t value = 0b01010110; // C++14 Standard Extension
    uint8_t mask =  0b00001111; // mask lower nibble
    uint8_t position = 0;       // for later use is position of bit in mask
    uint8_t result;
    // scanf("%d", &value);
    printf("value : ");
    print_binary(value);        // call function print_binary
    printf("\nmask  : ");
    print_binary(mask);
    result = mask & value;
    myleds = result;
    printf("\nresult: ");
    print_binary(myleds.read());
 
    printf("\n\nshift left:  %X\n", result<<1);
    printf("shift right: %X\n",     result>>1);

    while(1)
    {
        myleds = value;
        wait_ms(1000);

        myleds = mask;
        wait_ms(1000);

        myleds = result;
        wait_ms(1000);
    }
}