#ifndef VM_H
#define VM_H

#include "tp.h"
#include "list.h"
#include "gc.h"
#include "builtins.h"
#include "ops.h"

tp_vm *_tp_init(void);
void tp_deinit(TP);
void tp_frame(TP,tp_obj globals,tp_code *codes,tp_obj *ret_dest);
void _tp_raise(TP,tp_obj e);
void tp_print_stack(TP);
void tp_handle(TP);
void _tp_call(TP,tp_obj *dest, tp_obj fnc, tp_obj params);
void tp_return(TP, tp_obj v);
int tp_step(TP);
void tp_run(TP,int cur);
tp_obj tp_call(TP, const char *mod, const char *fnc, tp_obj params);
tp_obj tp_import(TP, char const *fname, char const *name, void *codes);
tp_obj tp_exec_(TP);
tp_obj tp_import_(TP);
void tp_builtins(TP);
void tp_args(TP,int argc, char *argv[]);
tp_obj tp_main(TP,char *fname, void *code);
tp_obj tp_compile(TP, tp_obj text, tp_obj fname);
tp_obj tp_exec(TP,tp_obj code, tp_obj globals);
tp_obj tp_eval(TP, char *text, tp_obj globals);
tp_vm *tp_init(int argc, char *argv[]);

#endif
