#ifndef OPS_H
#define OPS_H

#include "tp.h"
#include "dict.h"
#include "list.h"
#include "misc.h"
#include "builtins.h"


tp_obj tp_str(TP,tp_obj self);
int tp_bool(TP,tp_obj v);
tp_obj tp_has(TP,tp_obj self, tp_obj k);
void tp_del(TP,tp_obj self, tp_obj k);
tp_obj tp_iter(TP,tp_obj self, tp_obj k);
tp_obj tp_get(TP,tp_obj self, tp_obj k);
int tp_iget(TP,tp_obj *r, tp_obj self, tp_obj k);
void tp_set(TP,tp_obj self, tp_obj k, tp_obj v);
tp_obj tp_add(TP,tp_obj a, tp_obj b);
tp_obj tp_mul(TP,tp_obj a, tp_obj b);
tp_obj tp_len(TP,tp_obj self);
int tp_cmp(TP,tp_obj a, tp_obj b);

#define TP_OP(name,expr) \
    tp_obj name(TP,tp_obj _a,tp_obj _b) { \
    if (_a.type == TP_NUMBER && _a.type == _b.type) { \
        tp_num a = _a.number.val; tp_num b = _b.number.val; \
        return tp_number(expr); \
    } \
    tp_raise(tp_None,"%s(%s,%s)",#name,TP_CSTR(_a),TP_CSTR(_b)); \
}

tp_obj tp_and(TP,tp_obj _a,tp_obj _b);
tp_obj tp_or(TP,tp_obj _a,tp_obj _b);
tp_obj tp_mod(TP,tp_obj _a,tp_obj _b);
tp_obj tp_lsh(TP,tp_obj _a,tp_obj _b);
tp_obj tp_rsh(TP,tp_obj _a,tp_obj _b);
tp_obj tp_sub(TP,tp_obj _a,tp_obj _b);
tp_obj tp_div(TP,tp_obj _a,tp_obj _b);
tp_obj tp_pow(TP,tp_obj _a,tp_obj _b);


#endif
