#include "mbed.h"

Ticker toggle_led_ticker;

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);

volatile uint8_t counter = 0;

void toggle_led() {
    led1 = counter & 1;
    led2 = counter & 2;
    led3 = counter & 4;
}

int main() {
    // Init the ticker with the address of the function (toggle_led) to be attached and the interval (100 ms)
    toggle_led_ticker.attach(&toggle_led, 0.1);
    while (true) {
        counter += 1;
        wait(1);
        // Do other things...
    }
}