
#include "mbed.h"
#include "TCPSocket.h"
#include "HTTPClient.h"
InterruptIn mybutton(USER_BUTTON);
char str[30], str2[30];
DigitalOut myled(LED1);
SpwfSAInterface spwf(D8, D2, PC_12, PC_8, false);
HTTPClient http(spwf);
int ret;
int i=0,y=1,x=-1,h=0;
bool connessione=false;
// Funzione servita all'occorrenza dell'interrupt
void premuto()
{
    if (i==0)
    {
        connessione=true;
        h=1;
    }
    else
    {
        connessione=false;
        h=2;
    }
    i=i+y;
    y=y*x; 
}
int main() 
{     
    // Assegna all'interrupt la funzione premuto
    mybutton.fall(&premuto);    
    while(1) 
    {
        if (h==1)
        {
            //CONNESSIONE ALL'ACCESS POINT
            printf("\n\r");
            printf("Connessione all'Access Point\n\r");  
            spwf.connect("eliappsk","Pluto2018", NSAPI_SECURITY_WPA2);
            const char *ip = spwf.get_ip_address();
            printf("Indirizzo IP: %s\n\r", ip);  
            h=0;   
        }
        if (h==2)
        {
            printf("\n\r");
            spwf.disconnect();
            printf ("WIFI Disconnesso\n\r");  
            h=0;         
        }                
        if (i==1)
        {
            //LETTURA DEI DATI
            printf("\n\r");
            printf("Lettura Dati...\n\r");
            ret = http.get("http://www.itirenatoelia.gov.it/allegati/hello4.html", str, 30, HTTP_CLIENT_DEFAULT_TIMEOUT);
            if (!ret)
            {
                printf("Dati Letti Con Successo - Letti %d Caratteri\n\r", strlen(str));
                printf("Risultato: %s\n\r", str);
            }
            else
            {
                printf("Errore - ret = %d - Codice Errore HTTP = %d\n\r", ret, http.getHTTPResponseCode());
            }
            
            //POSTARE I DATI 
            myled=!myled; 
            strcpy(str2,str);
            HTTPMap map;
            HTTPText inText(str, 30);
            map.put("nome",str);
            printf("\n\r");
            printf("Invio Dati...\n\r");
            ret = http.post("http://www.itirenatoelia.gov.it/allegati/scrivi.php", map, &inText, HTTP_CLIENT_DEFAULT_TIMEOUT);
            if (!ret)
            {
                printf("Dati Inviati Con Successo - Scritti %d Caratteri\n\r", strlen(str2));
                printf("Risultato: %s\n\r", str2);
                
            }
            else
            {
                printf("Errore - ret = %d - Codice Errore HTTP = %d\n\r", ret, http.getHTTPResponseCode());
            }
             myled=!myled; 
        }
        wait(5);   
    }
}