/* My Digital Signal Controller library
 * Copyright (c) 2019, Gastón H. SALAZAR-SILVA
 * SPDX-License-Identifier: Apache-2.0
 * 
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * 
 * You may obtain a copy of the License at http://www.apache.org/licenses/LICENSE-2.0
 * 
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied.
 * 
 * See the License for the specific language governing permissions and limitations under the License.
 */

#include "mydsc_ring_buffer.h"

#include <stdlib.h>

int mydsc_ring_buffer_init(mydsc_ring_buffer_t *prb, uint32_t size)
{
  int nmsg = -1;
  uint32_t array_size;
  
  if (NULL != prb) {
    array_size = 1;
    while (array_size < size)
        array_size = array_size << 1;
    prb->max_position = array_size-1;
    prb->index = 0;
    prb->samples = (float*) malloc( array_size*sizeof(float) );
    nmsg = 0;
  }
  return nmsg;
}

void mydsc_ring_buffer_push(mydsc_ring_buffer_t *ring, float input)
{
  ring->index++;
  ring->index &= ring->max_position;
  ring->samples[ring->index] = input;
}
