/** @file: mydsc_kvp.h
    @author Gastón H. Salazar-Silva <gaston_salazar@yahoo.com>
    
    @brief A very basic key-value pair system is implemented. 
**/

#ifndef MYDSC_KVP_H
#define MYDSC_KVP_H

#include "mydsc_error.h"

#include <stdint.h>

#ifdef __cplusplus
extern "C" {
#endif

/// The structure sets a linked list up.
typedef struct mydsc_kvp_struct {
    char *key;
    char* (*get_function)(void);
    int (*set_function)(char*);
    struct mydsc_kvp_struct *next_kvp;
} mydsc_kvp_t;

/// Initialize the linked list, then puts a first key ("version")
/// @param pkv is a pointer to the linked list. 
int mydsc_kvp_init(mydsc_kvp_t* pkv);

/// Returns the value associated with a key.
/// @param pkv is a pointer to the linked list. 
/// @param key  is a character string to look-up in the linked list.
/// @return The value associated to the key, as a character string. 
char* mydsc_kvp_get_value(mydsc_kvp_t* pkv, char* key);

/// Sets or change the value associated with a key.
/// @param pkv is a pointer to the linked list. 
/// @param key  is a character string to look-up in the linked list.
/// @param value is the new setting, encoded as a character string.
/// @return an error encoded as a mydsc_kvp_errno_t.
int mydsc_kvp_set_value(mydsc_kvp_t* pkv, char* key, char* value);

/// Appends a new key-value pair into the linked list.
/// @param pkv is a pointer to the linked list. 
/// @param key  is a character string to look-up in the linked list.
/// @param get_function is a pointer to a function.
/// @param set_function is a pointer to a function.
/// @return an error encoded as a mydsc_kvp_errno_t.
int mydsc_kvp_append(mydsc_kvp_t* pkv, char* key,
                    char* (*get_function)(void),
                    int (*set_function)(char*));

#ifdef __cplusplus
}
#endif

#endif // MYDSC_KVP_H
