/** 
    @file   main.cpp
    @author Gastón SALAZAR  <gaston_salazar@yahoo.com>
*/

#include "mbed.h"
#include "stdio.h"
#include "stdlib.h"
#include "string.h"
#include "ctype.h"

#include "mydsc_kvp.h"
#include "mydsc_error.h"

// Hardware Interface
DigitalOut  led     (LED1);
Serial      serial  (USBTX, USBRX);
InterruptIn button  (USER_BUTTON);


// Behavior interface
const unsigned          MESSAGE_MAX_LEN = 126;
const char              END_OF_LINE     = 015;
const unsigned          VALUE_SIZE      = 128;
const unsigned short    BUFFER_SIZE     = 128;

unsigned long delay = 5000000UL;

char message[MESSAGE_MAX_LEN+2];

volatile bool semaphore_input = false;
volatile bool semaphore_button = false;

// This set of functions are callbacks

void on_rx() 
{
    static char c;
    static unsigned index = 0;
    
    c = serial.getc();
    message[index] = c;
    index++;
    message[index] = '\0';
    if ((END_OF_LINE == c) || (MESSAGE_MAX_LEN+1) == index) {
        semaphore_input = true;
        index = 0;
    }
}

void on_user_button() 
{
    semaphore_button = !semaphore_button;
    serial.printf("\r\n%s\r\nOk > ", (semaphore_button? "Paused": "Running"));
}
 
char* get_delay(void)
{
    static char value[VALUE_SIZE];
    
    sprintf(value, "%lu", delay);
    return value;       
}

int set_delay(char* value)
{
    sscanf(value, "%lu", &delay);
    return MYDSC_SUCCESS;
}

int main()
{
    // Setup
    static char     command_buffer[BUFFER_SIZE];
    static char     key_buffer[BUFFER_SIZE];
    static char     value_buffer[BUFFER_SIZE];
    long unsigned   delay_count     = delay;

    Serial      serial(USBTX, USBRX);
    serial.baud(9600);
    serial.printf("\r\nHello, world!");   

    // Setting the key-value list up
    mydsc_kvp_t kvp; 
    mydsc_kvp_init(&kvp);

    // Setting the callbacks up
    serial.attach(&on_rx, Serial::RxIrq);
    button.fall(&on_user_button);
    mydsc_kvp_append(&kvp, "delay",  &get_delay, &set_delay);
    serial.printf("\r\nOK > ");
    
    led = 1;

    while(1) {
        // Loop
        int result = 0;
        char* value = "";
        
        if (semaphore_input == true) {
            semaphore_input = false;
            strcpy(command_buffer, strtok(message," \015"));
            if (strcmp(command_buffer, "set") == 0) {
                strcpy(key_buffer, strtok(NULL," \015"));
                strcpy(value_buffer, strtok(NULL, " \015"));
                result = mydsc_kvp_set_value(&kvp, key_buffer, value_buffer);
                if (result != MYDSC_SUCCESS)
                    serial.printf("\r\nError: %s", mydsc_error[result]);            
            }
            else if (strcmp(command_buffer,"get") == 0) {
                strcpy(key_buffer, strtok(NULL," \015"));
                value = mydsc_kvp_get_value(&kvp,key_buffer);
                if (NULL != value)
                    serial.printf("\r\n%s", value);
                else
                    serial.printf("\r\nError: %s", mydsc_error[MYDSC_KVP_NO_KEY]);            
            }
                else if (strcmp(command_buffer,"help") == 0) {
                    serial.printf("\r\nAvailable commands are: get help set");
                }
            else
                serial.printf("\r\nError: %s doesn't exist\r\n", command_buffer);
           serial.printf("\r\nOk > ");            
        }
        if (!delay_count) {
            led = !led;
            delay_count = delay;
        }
        if (!semaphore_button)
            delay_count--;
    }
}
