

#include "EthernetInterface.h"
#include <stdlib.h>
#include <string.h>
#include "mbed.h"
#include "rtos.h" // need for main thread sleep
#include "html.h" // need for html patch working with web server
#include "bloc_io.h"    //need for stating the PLD
#define RADIUS  0.2F // wheel size
#define NBPOLES 20 // magnetic pole number
#define DELTA_T 0.1F // speed measurement counting period
#define Ioffset 0.17 // offset value added to the current measurement (measurement uncertainty correction)
#define dT 1 // battery capacity measurement counting period in second
Bloc_IO MyPLD(p25,p26,p5,p6,p7,p8,p9,p10,p23,p24);// instantiate object needed to communicate with PLD
AnalogIn ngaz(p17);        // reading handle command analog input connected to mbed
AnalogIn Tension(p18);  //Voltage measurement variable
AnalogIn iTemperature(p19);  //iTemperature measurement variable
AnalogIn Imes(p20);     //Current measurement variable
DigitalOut valid_pwm(p21);// valid pwm mbed pin
InterruptIn Hall(p22);// Top_Hall Pinw
Serial pc(USBTX, USBRX); // tx, rx


/************ persistent file parameters section *****************/
LocalFileSystem local("local");               // Create the local filesystem under the name "local"


/********************* web server section **********************************/

var_field_t tab_balise[10];  //une balise est présente dans le squelette
int iCounter=0;
int giCounter=0;// acces counting
int iREF_PWM=0;
int iREF_PWMfin=0;
int iFrein=0;
int iTemperature;
float fngazmin=0;
float fngazmax=0;
float fnbhall=0;
float fVRoue=0;
float fBride=50;
float fImes;
float fVmes;
float fPositionPoignee;
float fCapaInit;//en mAs
float fCapa;
float fdistance=0;//Variable pour compteur kilometrique
float fdistpartiel=0;
float ftop_hall_total=0;//nbre de top hall
float ftop_hall_partiel=0;//nbre de top hall
float fngaz;
char cChoix='e'; //Variable pour choisir l'état
Ticker Tgaz;    //Handle reading Tick
Ticker Vitesse; //Speed reading Tick
Ticker Tbat;    //Battery reading Tick

/*********************** can bus section  ************/
// determine message ID used to send Gaz ref over can bus
#define _CAN_DEBUG // used to debug can bus activity
//#define USE_CAN_REF // uncomment to receive gaz ref over can_bus
CAN can_port (p30, p29); // initialisation du Bus CAN sur les broches 30 (rd) et 29(td) for lpc1768 + mbed shield
bool bCan_Active=false;



DigitalOut led1(LED1); //initialisation des Leds présentes sur le micro-controleur Mbed*/
DigitalOut led2(LED2);
DigitalOut led3(LED3); // blink when can message is sent
DigitalOut led4(LED4); // blink when can message is received





//************ local function prototypes *******************

/**************** Read persistent data from text file located on local file system ****************/

/**************** write persitant  data to text file located on local file system ****************/

//************** calibation gaz function needed to record min_gaz and max_gaz value to persistent text file  ******************

// ************top hall counting interrupt needed for speed measurement

//********************** timer interrupt for speed measurement each 100ms  *************************

//********************* Timer Interrupt for gaz ref management each 10ms   ********************

/********* main cgi function used to patch data to the web server thread **********************************/
void CGI_Function(void) // cgi function that patch web data to empty web page
{
    char ma_chaine4[20]= {}; // needed to form html response
    
    sprintf (ma_chaine4,"%g",fVRoue*3.6);// convert speed as ascii string
    Html_Patch (tab_balise,0,ma_chaine4);// patch first label with dyn.string
    sprintf (ma_chaine4,"%g",fPositionPoignee*100);// convert speed as ascii string
    Html_Patch (tab_balise,1,ma_chaine4);// patch second label with dyn.string
    sprintf (ma_chaine4,"%d",iTemperature);// convert speed as ascii string
    Html_Patch (tab_balise,2,ma_chaine4);// patch third label with dyn.string
    sprintf (ma_chaine4,"%g",fImes);// convert speed as ascii string
    Html_Patch (tab_balise,3,ma_chaine4);// patch fourth label with dyn.string
    sprintf (ma_chaine4,"%g",fVmes);// convert speed as ascii string
    Html_Patch (tab_balise,4,ma_chaine4);// patch fourth label with dyn.string
}

/*********************** CAN BUS SECTION  **********************/
void CAN_REC_THREAD(void const *args)
{
    int iCount,iError;

    while (bCan_Active) {
        Thread::wait(100);// wait 100ms
        // code todo

    }

}

void GazRead(void)
{
    if(cChoix == 'a'){}
    else
    {
        nGaz=ngaz.read();
        fImes=(((Imes.read()*3.3*1.81818 - 2.5)/0.185)+Ioffset)*1000; //Current measurement (A to mA conversion) (on p20)
        fVmes=(Tension.read()*15/0.19);                               //Voltage measurement (on p18)
        iTemperature=iTemperature.read()*3.3/0.01-273;                //Temperature measurement (on p19)
        
        fPositionPoignee=(ngaz.read()-ngazmin)/(ngazmax-ngazmin); // 0 to 1 float value meaning handle position
        if(fPositionPoignee>1)
            {
                fPositionPoignee=1;
            }
            if(fPositionPoignee<0)
            {
                fPositionPoignee=0;
            }
        iREF_PWM=(255/(ngazmax-ngazmin))*(nGaz-ngazmin); //calibrate PWM (0 to 255)
        iFrein=MyPLD.read()&32; //testing 6th Bit value 
        if(iFrein==32) //if brake is off
        {
            if(iREF_PWM>=255) iREF_PWM= 255;
            if(iREF_PWM<1) iREF_PWM = 0;
            if (fVRoue*3.6<=fBride) //speed flange
            {
                /******************* Progressive speed control *****************/
                if(iREF_PWMfin<iREF_PWM) iREF_PWMfin=iREF_PWMfin+1;
                else iREF_PWMfin=iREF_PWM;
                MyPLD.write(iREF_PWMfin);
            }
            else 
            {
                if(iREF_PWMfin>0)
                {
                iREF_PWMfin=iREF_PWMfin-1;
                MyPLD.write(iREF_PWMfin);
                }
                else iREF_PWMfin=0;
            }
        }
               /******************* End of speed control *******************/
               
        if(iFrein==0) //if brake is on
        {
            iREF_PWM=0;
            MyPLD.write(iREF_PWM);
        }
    }
}

void cpt (void){
    nbhall++;
}

void VitesseRoue (void)
{
    fVRoue=(nbhall*2*3.14*RADIUS)/(6*DELTA_T*NBPOLES);  //Wheel speed in m/s
    ftop_hall_total=nbhall+ftop_hall_total;
    ftop_hall_partiel=nbhall+ftop_hall_partiel;
    nbhall=0;
}

void Battery(void){
    
    fCapa = fCapa - 1000*dT;         //Init battery capacity with dT : counting period and 1000 the current value in mA
    
    if(fCapa<0){
        fCapa=0;
    }
}

/*char getValeur(char octet, char n)
{
   return (octet & (1 << n));
}*/


//*************************** main function *****************************************
int main()
{
    valid_pwm.write(0);
    MyPLD.write(0);
    char cClavier= 0;
    valid_pwm.write(1);
    
    FILE *fp = NULL;
    fp = fopen("/local/Config2.txt", "r");
    if(fp != NULL){
        fscanf(fp,"%g %g %g %g %g %g %g",&ngazmin,&ngazmax,&fBride,&ftop_hall_total,&ftop_hall_partiel,&fCapa,&fCapaInit); //Writing values in file
        fclose(fp);
        pc.printf("Max=%g\n\r",ngazmax);
        pc.printf("Min=%g\n\r\n",ngazmin);
        pc.printf("Bride=%g\n\r\n",fBride);
        fdistance=(ftop_hall_total/(6*NBPOLES)*2*3.14*RADIUS); // meters
        fdistpartiel=(ftop_hall_partiel/(6*NBPOLES)*2*3.14*RADIUS); // meters
        pc.printf("Distance totale enregistree=%g m\n\r\n",fdistance);
        pc.printf("Distance partiel enregistree=%g m\n\r\n",fdistpartiel);
        pc.printf("Capa batterie restante: %g\n\r",fCapa);
        pc.printf("Capa initale batterie: %g\n\r",fCapaInit);
        }
    else printf("Fichier introuvable\n\r");

//***************************************** web section ********************************************//

Init_Web_Server(&CGI_Function); // create and initialize tcp server socket and pass function pointer to local CGI function
Thread WebThread(Web_Server_Thread);// create and launch web server thread

    /********* main cgi function used to patch data to the web server thread **********************************/
    
Gen_HtmlCode_From_File("/local/pagecgi2.htm",tab_balise,5);*/// read and localise ^VARDEF[X] tag in empty html file

//******************************************* end web section  ************************************* /

    pc.printf("\rprogramme scooter mbed \n\r");

//********************* can bus section initialisation *******************************************
//bCan_Active=true;// needed to lauchn CAN thread
//Thread CanThread(CAN_REC_THREAD);// create and launch can receiver  thread
//********************* end can bus section *****************************************************
fCapaInit=1000*60;
Tgaz.attach(&GazRead,0.005);
Tbat.attach(&Battery,dT);
Hall.mode(PullUp);
Hall.rise(&cpt);
Vitesse.attach(&VitesseRoue,DELTA_T);
pc.printf("commande moteur par poignee\n\r");

while (1)
{   /****************************** MBed IHM **********************/
    pc.printf("veuillez saisir une commande parmi la liste proposee: \n\r");
    pc.printf("a:saisie consigne pwm \n\r");
    pc.printf("z:calibration poignee \n\r");
    pc.printf("e:controle vitesse poignee \n\r");
    pc.printf("r:Affichage registre interne\n\r");
    pc.printf("t:vitesse roue\n\r");
    pc.printf("y:bride en vitesse\n\r");
    pc.printf("u:affichage mesures\n\r");
    pc.printf("i:distance totale et partielle en metre\n\r");
    pc.printf("o:RAZ compteur kilometrique\n\r");
    pc.printf("p:Capacite restante \n\r");
    pc.printf("d:Recharge\n\r");
    pc.printf("q:quitter \n\n\r");
    /**************************** END IHM ***********************/
    
    /************* multithreading : main thread need to sleep in order to allow web response ****************/
while (pc.readable()==0) // determine if char availabler
{Thread::wait(10);} // wait 10 until char available on serial input
    /************* end of main thread sleep  ****************/

    pc.scanf("%c",&cChoix);
    switch (cChoix) {
        case 'a':       //Manual PWM command
            pc.printf("Entrez la valeur PWM entre 0 et 255 : \n\r");
            while (pc.readable()==0) { // determine if char available
                Thread::wait(10);
            }
            pc.scanf("%d",&iREF_PWM);
            if(iREF_PWM<=255 & iREF_PWM>=0) {
                printf("Envoie d'une commande %d/255 dans la roue\n\r",iREF_PWM);
                MyPLD.write(iREF_PWM);
            }
            else 
                pc.printf("value %d out of range PWM remains unchanged\n\r",iREF_PWM);
            break;
            
            
        case 'z':      //Manual Handle calibration
            pc.printf("Mettez la poignee a la valeur min puis entrez o\n\r");
            pc.scanf("%c",&cClavier);
            if(cClavier=='o') {
                ngazmin=ngaz.read();
            } else {
                while(cClavier!='o') {
                    pc.printf("tapez o\n");
                    pc.scanf("%c",&cClavier);
                }
            }
            
            pc.printf("Mettez la poignee a la valeur max puis entrez o\n\r");
            pc.scanf("%c",&cClavier);
            if(cClavier=='o') {
                ngazmax=ngaz.read();
            } else {
                while(cClavier!='o') {
                    pc.printf("tapez o\n");
                    pc.scanf("%c",&cClavier);
                }
            }
            
            pc.printf("Max=%g\n\r",ngazmax); 
            pc.printf("Min=%g\n\r\n",ngazmin);
            fp = fopen("/local/Config2.txt", "w");
            fprintf(fp,"%g %g %g %g %g", ngazmin, ngazmax,fBride,ftop_hall_total,ftop_hall_partiel);
            fclose(fp);
            break;


        case 'e':   //Wheel speed control only (using handle)
            pc.printf("commande moteur par poignee\n\r");
            break;

        case 'r':   //Internal register : reading PLD 1st to 6th bits (
            
            int RegPLD = MyPLD.read();
            
            pc.printf("Registre interne : %d\n\r",RegPLD );                     //Reading all Bits in PLD
            
            pc.printf("Numero secteur hall : %d\n\n\r",RegPLD & 7);             //Current sector
            
            if((RegPLD & 0x20) == 0x00) pc.printf("Etat frein: actif\n\n\r");   //Testing brake
            else pc.printf("Etat frein: inactif\n\n\r");
            
            if((RegPLD & 0x08) == 0x08) pc.printf("Direction: avant \n\n\r");   //Testing direction
            else pc.printf("Direction: arriere \n\n\r");
            
            if((RegPLD & 0x10) == 0x10) pc.printf("Defaillance detecte \n\n\r");//Testing system failure
            else pc.printf("Pas de defaillance \n\n\r");
            
            if((RegPLD & 0x40) == 0x00) pc.printf("Surintensite detecte \n\n\r");//Testing overcurrent
            else pc.printf("Pas de surintensite \n\n\r");
            break;    
            
        case 't':
            pc.printf("Vitesse roue : %gm/s\n\r",fVRoue);       //Reading wheel speed : km/h and m/s
            pc.printf("Vitesse roue : %gkm/h\n\r",fVRoue*3.6);
        break;
        
        case 'y':
            pc.printf("Choisissez une vitesse limite en km/h \n\r");            //Wheel speed flange configuration
            pc.scanf("%g",&fBride);
            fp = fopen("/local/Config2.txt", "w");
            fprintf(fp,"%g %g %g %g %g", ngazmin, ngazmax,fBride,ftop_hall_total,ftop_hall_partiel);
            fclose(fp);
        break;
        
        case 'u':
            pc.printf("Mesure courant: %gA\n\r",fImes/1000); //Ampere
            pc.printf("Mesure tension: %gV\n\r",fVmes);      //Voltage
            pc.printf("iTemperature: %d\n\r",iTemperature);  //°C
            pc.printf("Poignee a: %g",fPositionPoignee*100); //0 to 100%
            pc.puts("%\n\r");
            break;
            
        case 'i':
            fdistance=(ftop_hall_total/(6*NBPOLES)*2*3.14*RADIUS); // total distance traveled in meters
            fdistpartiel=(ftop_hall_partiel/(6*NBPOLES)*2*3.14*RADIUS); // current session distance traveled in meters
            pc.printf("distance totale=%g m\n\r",fdistance);
            pc.printf("distance partiel=%g m\n\r",fdistpartiel);
            break;
            
        case 'o':
            pc.printf("RAZ\n\r");
            ftop_hall_partiel = 0;      //Current session distance reset
            break;
            
        case 'p':
            pc.printf("Capa batt restante:%.2f\n\r",(fCapa/fCapaInit)*100); //battery remaining
            break;
            
        case 'd':
            fCapa=fCapaInit;
            pc.printf("Recharge de la batterie effectuee\n\r");     //Battery recharger
            break;
            
        case 'q':
            /********************** END of program (save all) *******************/
            pc.printf("Capa batterie restante: %.2f\n\r",fCapa);
            pc.printf("Capa initale batterie: %.2f\n\r",fCapaInit);
            pc.printf("%g m parcourus cette session\n\r",fdistpartiel);
            fp = fopen("/local/Config2.txt","w");
            fprintf(fp,"%g %g %g %g %g %g %g", ngazmin, ngazmax,fBride,ftop_hall_total,ftop_hall_partiel,fCapa,fCapaInit);
            fclose(fp);
            Tgaz.detach();
            Vitesse.detach();
            Tbat.detach();
            MyPLD.write(0);
            pc.printf(" fin programme scooter mbed \n");
            return 0;
    }
} // end while

    //************** thread deinit *********************
   // DeInit_Web_Server();
    //bCan_Active=false;
    //CanThread=false;// close can received thread
} // end main