#include "mbed.h"
#include "VCNL40x0.h"
#include "NeoStrip.h"
#define  NumPixels 4

I2C i2c(p28, p27);
DigitalOut mled0(LED1); 
DigitalOut mled1(LED2); 
DigitalOut mled2(LED3); 
DigitalOut mled3(LED4); 
Serial pc(USBTX, USBRX);
DigitalOut reset(p29);
NeoStrip strip(p26, NumPixels);
DigitalIn interrupt (p25);

const uint8_t MUX = 0xE0; // 11100000
const uint8_t VCNL4020 = 0x26;
unsigned int sensors[4];
char _send[3];
char _receive[2];
char port[2];
const uint8_t chan0 = 0x01;
const uint8_t chan1 = 0x02;
const uint8_t chan2 = 0x04;
const uint8_t chan3 = 0x08;
const uint8_t chan[] = {chan0,chan1,chan2,chan3};
int mleds[] = {0,0,0,0};

void Setup(void);
void SetupAllChannels(void);
void Setmleds(void);
void SwitchChannel(uint8_t chan);
void ReadOne(uint8_t channel);
void ReadAllSensors(void);
void Setmleds(void);
void SetProximityRate (unsigned char ProximityRate);
void SetCommandRegister (unsigned char Command);
void ReadCommandRegister (unsigned char *Command);
void SetCurrent (unsigned char Current);
void ReadCurrent (unsigned char *Current);
void ReadProxiValue (unsigned int *ProxiValue);
void SetProximityRate (unsigned char ProximityRate);
void SetInterruptControl (unsigned char InterruptControl);
void ReadInterruptControl (unsigned char *InterruptControl);
void ReadProxiOnDemand (unsigned int *ProxiValue);


////////////////////////////////////////////////////////////////////////////////////////////////////////////////

int main() {
    wait_ms(5);
    //SwitchChannel(chan1);            // set channel
    //wait_ms(50);
    //Setup();
    SetupAllChannels();
    
    while (1) {
        
        ReadAllSensors();
        //ReadOne(chan1);
    }
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////
 
// setup for VCNL4020. 
    
void Setup(void) {
    unsigned char Current=0;
    
    
 
    SetCurrent(20);                              // Set current to 200mA
    ReadCurrent(&Current);
    pc.printf("\n IR LED Current: %d\n", Current);
    SetCommandRegister (COMMAND_ALL_DISABLE);    // ready for prox rate change
    SetProximityRate (PROX_MEASUREMENT_RATE_31); // 31 measurements/s
    SetInterruptControl (INTERRUPT_THRES_SEL_PROX |INTERRUPT_THRES_ENABLE |INTERRUPT_COUNT_EXCEED_1);
    SetCommandRegister (COMMAND_PROX_ENABLE | COMMAND_SELFTIMED_MODE_ENABLE);
    pc.printf("\r done\n");
    wait(0.2);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Setup all channels sequentially. 

void SetupAllChannels(void){
    
    
    pc.baud(115200);
    i2c.frequency(1000000);   
    SwitchChannel(chan0);            // set channel
    wait_ms(20);
    Setup();
    SwitchChannel(chan1);            // set channel
    wait_ms(20);
    Setup();
    SwitchChannel(chan2);            // set channel
    wait_ms(20);
    Setup();
    SwitchChannel(chan3);            // set channel
    wait_ms(20);
    Setup();
    pc.printf("\r setup ok \n ");
    }
    
////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// mbed leds for some visual recognition.

void Setmleds(void){
    mled0 = mleds[0];
    mled1 = mleds[1];
    mled2 = mleds[2];
    mled3 = mleds[3];
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// reset MUX and choose channel.

void SwitchChannel(uint8_t chan){
        //i2c.start();
        reset = 0;
        wait_ms(10);
        reset = 1;
        wait_ms(10);    
        port[0] = chan;
        i2c.write(MUX,port, 1);
        //i2c.stop();
    }

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Choose on channel and read proximity from that channel.

void ReadOne(uint8_t channel){
    
    unsigned int sensor = 0; 
    SwitchChannel(channel);            // set channel
        i2c.start();
        mleds[0] = 1;                      // LED on
        Setmleds();
        ReadProxiOnDemand(&sensor);    // read prox value on demand
        mleds[0] = 0;                      // LED off
        Setmleds();   
        pc.printf("\r %i \n", sensor);
        i2c.stop();
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

// Read all sensors sequentially

void ReadAllSensors(void){
    
    for (int i = 0; i < 4; i++){
        
        unsigned int sensor = 0; 
        
        SwitchChannel(chan[i]);            // set channel
        //i2c.start();
        mleds[i] = 1;                      // LED on
        Setmleds();
        //ReadProxiValue(&sensor);
        ReadProxiOnDemand(&sensor);        // read prox value on demand
        wait_ms(10); 
        mleds[i] = 0;                      // LED off
        Setmleds();   
        sensors[i] = sensor;
        pc.printf("\r %i ", sensors[i]);
        //i2c.stop();
        }
        
    pc.printf("\r \n ");
    wait(0.001);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetCommandRegister (unsigned char Command) {
    
    _send[0] = REGISTER_COMMAND;            // VCNL40x0 Configuration reister
    _send[1] = Command;
    i2c.write(VCNL4020,_send, 2);           // Write 2 bytes on I2C
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReadCommandRegister (unsigned char *Command) {
    
    _send[0] = REGISTER_COMMAND;              // VCNL40x0 Configuration register
    i2c.write(VCNL4020,_send, 1);             // Write 1 byte on I2C
    i2c.read(VCNL4020+1,_receive, 1);         // Read 1 byte on I2C

    *Command = (unsigned char)(_receive[0]);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetCurrent (unsigned char Current) {

    _send[0] = REGISTER_PROX_CURRENT;              // VCNL40x0 IR LED Current register
    _send[1] = Current;
    i2c.write(VCNL4020,_send, 2);                  // Write 2 bytes on I2C

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReadCurrent (unsigned char *Current) {

    _send[0] = REGISTER_PROX_CURRENT;                       // VCNL40x0 IR LED current register
    i2c.write(VCNL4020,_send, 1);                  // Write 1 byte on I2C
    i2c.read(VCNL4020+1,_receive, 1);              // Read 1 byte on I2C

    *Current = (unsigned char)(_receive[0]);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReadProxiValue (unsigned int *ProxiValue) {

    _send[0] = REGISTER_PROX_VALUE;                // VCNL40x0 Proximity Value register
    i2c.write(VCNL4020, _send, 1);                 // Write 1 byte on I2C
    i2c.read(VCNL4020+1, _receive, 2);             // Read 2 bytes on I2C
    *ProxiValue = ((unsigned int)_receive[0] << 8 | (unsigned char)_receive[1]);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetProximityRate (unsigned char ProximityRate) {

    _send[0] = REGISTER_PROX_RATE;                 // VCNL40x0 Proximity rate register
    _send[1] = ProximityRate;
    i2c.write(VCNL4020,_send, 2);                  // Write 2 bytes on I2C
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void SetInterruptControl (unsigned char InterruptControl) {

    _send[0] = REGISTER_INTERRUPT_CONTROL;                  // VCNL40x0 Interrupt Control register
    _send[1] = InterruptControl;
    i2c.write(VCNL4020,_send, 2);                  // Write 2 bytes on I2C

}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReadInterruptControl (unsigned char *InterruptControl) {

    _send[0] = REGISTER_INTERRUPT_CONTROL;                  // VCNL40x0 Interrupt Control register
    i2c.write(VCNL4020,_send, 1);                  // Write 1 byte on I2C
    i2c.read(VCNL4020+1,_receive, 1);              // Read 1 byte on I2C

    *InterruptControl = (unsigned char)(_receive[0]);
}

////////////////////////////////////////////////////////////////////////////////////////////////////////////////

void ReadProxiOnDemand (unsigned int *ProxiValue) {

    unsigned char Command=0;
    
    // SetCommandRegister (COMMAND_ALL_DISABLE);
    
    SetCommandRegister (COMMAND_PROX_ENABLE | COMMAND_PROX_ON_DEMAND);
 
    // wait on prox data ready bit
    do {
        ReadCommandRegister (&Command);                     // read command register
    } while (!(Command & COMMAND_MASK_PROX_DATA_READY));

    ReadProxiValue (ProxiValue);                            // read prox value

    SetCommandRegister (COMMAND_ALL_DISABLE);               // stop prox value on demand
    
}