#include "mbed.h"
#include "VCNL40x0.h"

#define BAUD    115200

//const char chan0 = 0001;
//const char chan1 = 0010;
//const char chan2 = 0100;
//const char chan3 = 1000;
//const char all = 1111;

const int MUX = 0x60; // 11100000
unsigned int sensors[4];

I2C i2c(p28, p27);
VCNL40x0 VCNL40x0_Device (p28, p27, VCNL40x0_ADDRESS);      // Define SDA, SCL pin and I2C address
DigitalOut mled0(LED1);                                     // LED #1
Serial pc(USBTX, USBRX);                                    // Tx, Rx USB transmission

int main() {
    
    unsigned int sensors[4];
    char chan[] = {0x01,0x02,0x04,0x08};
    pc.baud(BAUD);                                          // set USB speed (virtual COM port)
    
    for (int i = 0; i < 4; i++){
            char port[2];
            port[0] = 0;
            port[1] = chan[i];
            i2c.write(MUX,port, 2);
            VCNL40x0_Device.SetCurrent (20);                 // Set current to 200mA
        }
    
    while (1) {
        for (int i = 0; i < 4; i++){
            char port[2];
            port[0] = 0;
            port[1] = chan[i];
            i2c.write(MUX,port, 2);
            
            mled0 = 1;                                          // LED on
            VCNL40x0_Device.ReadProxiOnDemand (&sensors[i]);    // read prox value on demand
            mled0 = 0;                                          // LED off
        }
        for (int i = 0; i < 4; i++){
        pc.printf("\r %i ", sensors[i]);
        }
    pc.printf("\r \n ");
    }
}
