#include "mbed.h"
#include "QT60486.h"

#define NUM_KEYS 48

SPI captouch(p5,p6,p7);
DigitalOut qt_cs (p8);
DigitalOut qt_wake (p9);
DigitalIn qt_drdy (p10);
Serial pc(USBTX, USBRX);

uint16_t keydata[NUM_KEYS];
uint16_t * p;

void qt_signalAll(void);

bool qt_proxsetup(void);

bool qt_calAll(void);

void setup() {
    pc.baud(38400);
    pc.printf("baudset\r\n");
    captouch.format(8,3);
    pc.printf("formated\r\n");
    qt_cs = 1; // set pin high, disables communication
    while(qt_proxsetup() == false)
       {;;}   
    pc.printf("setup_done\r\n");
 }
 
 
int main()                     
 {
    setup();
    
   qt_signalAll();
   
   for(uint8_t i = 0; i < NUM_KEYS; i ++)
   {
   pc.printf("%i\t",keydata[i]); 
   }
   pc.printf("\r\n");
   
   wait(0.001);
 }
 

void qt_signalAll(void) 
  {
    qt_cs = 0;
    captouch.write(SIGNAL_ALL);
    while(qt_drdy == 0){
        for(uint8_t i = 0; i < NUM_KEYS; i ++ ){
            keydata[i] = ((captouch.write(0x00) << 8) & captouch.write(0x00));
             }
    }

};


   
 
 
bool qt_proxsetup(void)
  { 
    //bool ret = false;
    //qt_cs = 0;
    //uint8_t ret = 0x00;
    //while(captouch.write(0x0F) != 0xF0)
    //  {;;}
    //ret = captouch.write(ENTER_SETUP);
    //ret = captouch.write(ENTER_SETUP);
      
    //while(captouch.write(0x00) != 0xFE)
     // {;;}    
      
     // captouch.write(0x00);
     // captouch.write(0x00);
      
     // qt_cs = 1;
      
     // wait(0.025);
      
      qt_cs = 0;
      
      //captouch.write(FORCE_RESET);
    
      //while(captouch.write(0x0F) != 0xF0)
      //  {;;}  
      
      while(qt_calAll() == false)
        {;;}  
    
      pc.printf("caldone\r\n");
      captouch.write(REPORT_FIRST);
      
       if (qt_drdy == 0) {
            while (qt_drdy == 0)
            {;;}
            }
      
      if (captouch.write(0x00) != 0x3F)
            {qt_calAll();
            }  
      while(qt_calAll() == false)
        {;;}  
      
      return true;
  };
  
  
  bool qt_calAll(void)
      { 
      pc.printf("calibrating...\r\n");
        bool ret = false;
        captouch.write(CAL_ALL);
        if (qt_drdy == 0) {
            while (qt_drdy == 0)
            {;;}
            }
        captouch.write(CAL_ALL);
        if (qt_drdy == 0) {
            while (qt_drdy == 0)
            {;;}
            }
            pc.printf("comms...\r\n");
        while(captouch.write(0x00) != 0xFC)
            {;;}  
        
        //uint8_t genstat = captouch.write(GENERAL_STATUS);
        //ret = !(genstat & 0x04);
        ret = true;
        pc.printf("ret %i\r\n", ret);
        return ret; 
  }
  
  
  
  
  
  
  