// Edited from the Hello World example for the USBMIDI library
// to play notes from the PwmOut using beep.....

#include "mbed.h"
#include "USBMIDI.h"
#include "beep.h"

//USBMIDI object
USBMIDI midi;


Beep buzzer(p26);

int freq = 0;


//defining your midi notes as frequencies...
void show_message(MIDIMessage msg) {
    switch (msg.type()) {
        case MIDIMessage::NoteOnType:
            switch (msg.key()) {
                case 48:
                    freq = 261;
                    break;
                case 49:
                    freq = 277;
                    break;
                case 50:
                    freq = 293;
                    break;
                case 51:
                    freq = 311;
                    break;
                case 52:
                    freq = 329;
                    break;
                case 53:
                    freq = 349;
                    break;
                case 54:
                    freq = 369;
                    break;
                case 55:
                    freq = 391;
                    break;
                case 56:
                    freq = 415;
                    break;
                case 57:
                    freq = 440;
                    break;
                case 58:
                    freq = 466;
                    break;
                case 59:
                    freq = 493;
                    break;
                case 60:
                    freq = 523;
                    break;
                case 61:
                    freq = 554;
                    break;
                case 62:
                    freq = 587;
                    break;
                case 63:
                    freq = 622;
                    break;
                case 64:
                    freq = 659;
                    break;
                case 65:
                    freq = 698;
                    break;
                case 66:
                    freq = 739;
                    break;
                case 67:
                    freq = 783;
                    break;
                case 68:
                    freq = 830;
                    break;
                case 69:
                    freq = 880;
                    break;
                case 70:
                    freq = 932;
                    break;
                case 71:
                    freq = 987;
                    break;
                case 72:
                    freq = 1046;
                    break;
            }
            switch (msg.velocity()) {
                case 0:
                 freq = 0;
            }
            break;
        }
}

float note = 60; 

int main() {
    
    // call back for messages received
    midi.attach(show_message);
    
    while (1) {
    
    float note = freq;    
    if (note > 0){
        buzzer.beep(note,0.1);
        }
    
    wait ((0.01));
    }
}