/*

Copyright (c) 2012-2014 RedBearLab

Permission is hereby granted, free of charge, to any person obtaining a copy of this software 
and associated documentation files (the "Software"), to deal in the Software without restriction, 
including without limitation the rights to use, copy, modify, merge, publish, distribute, sublicense, 
and/or sell copies of the Software, and to permit persons to whom the Software is furnished to do so, 
subject to the following conditions:
The above copyright notice and this permission notice shall be included in all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR IMPLIED, 
INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR 
PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE 
FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, 
ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

*/

#include <string.h>
#include "mbed.h"
#include "wire.h"

#define SCL         7  
#define SDA         6

#define DEV_ADDR    0x80

TwoWire Wire = TwoWire(NRF_TWI0);

Serial pc(USBTX, USBRX);

uint16_t ReadHumidity(void);
int16_t ReadTemperature(void);

int main(void)
{
    uint16_t rh;
    int16_t t;
    char buf[200];
    
    pc.baud(9600);
    wait(5);
    
    Wire.begin(SCL, SDA, TWI_FREQUENCY_100K);

    while(1)
    {
        rh = ReadHumidity();
        t = ReadTemperature();
        
        sprintf(buf,"RH=%d, T=%d\r\n\0",rh,t);
        
        pc.printf(buf);
        wait(5);
    }
}




uint16_t ReadHumidity(void)
{
    uint16_t msbyte=0;
    uint16_t lsbyte=0;
    uint16_t checksum=0;
    uint16_t rhcode=0;
        
    Wire.beginTransmission(DEV_ADDR);

    Wire.write(0xE5);
    
    Wire.endTransmission(0);

    Wire.requestFrom(DEV_ADDR+1, 3);
    
    if(Wire.available())
    {
        msbyte = Wire.read();
    }
    if(Wire.available())
    {
        lsbyte = Wire.read();
    }
    if(Wire.available())
    {
        checksum = Wire.read();
    }
    
    rhcode = (((msbyte*256.0)+lsbyte)*125.0/65536.0-6.0)*100.0;
    
    if(rhcode<=0)
    {
        rhcode=0;
    }
    if(rhcode>=100*100)
    {
        rhcode=100*100;
    }
    return rhcode;
}
int16_t ReadTemperature(void)
{
    int16_t msbyte=0;
    int16_t lsbyte=0;
    int16_t checksum=0;
    
    Wire.beginTransmission(DEV_ADDR);

    Wire.write(0xE3);
    
    Wire.endTransmission(0);

    Wire.requestFrom(DEV_ADDR+1, 3);
    
    if(Wire.available())
    {
        msbyte = Wire.read();
    }
    if(Wire.available())
    {
        lsbyte = Wire.read();
    }
    if(Wire.available())
    {
        checksum = Wire.read();
    }
    
    return (((msbyte*256.0)+lsbyte)*175.72/65536.0-46.85)*100.0;
}


