#include "mbed.h"
#include "rtos.h"
#include "CAN_thread.h"

DigitalOut led1(LED1);
DigitalOut led2(LED2);
CAN can1(p9, p10);
CAN can2(p30, p29);
char counter1 = 0;

void sendBUS1(void const *args) {
    if(can1.write(CANMessage(1337, &counter1, 1))) {
        counter1++;
    } 
    led1 = !led1;
}

void CAN_thread (void const *args) {
    can1.frequency(125000);
    can2.frequency(125000);
    
    RtosTimer CAN1send(sendBUS1, osTimerPeriodic);
    CAN1send.start(1000);
    CANMessage msg;
    while(1) {
        if(can2.read(msg)) {
            led2 = !led2;
        } 
        Thread::wait(10);
    }
}