#include "spiSlaveProtocol.h"

spiSlaveProtocol::spiSlaveProtocol(Serial* PC) {
    spiLine = new SPISlave(p5, p6, p7, p8);
    spiLine->format(8,3);        // Setup:  bit data, high steady state clock, 2nd edge capture
    spiLine->frequency(1000000); // 1MHz
    
    pc = PC; // tx, rx
    pc->printf("======================================================\r\n");
    
    timout = new Timer();
    
    state = 0;
    commandBytes = 0;
}
 
 void spiSlaveProtocol::run() {
    if (spiLine->receive()) {
        int valueFromMaster = spiLine->read();
        
        if (valueFromMaster == 0x42) {
            spiLine->reply(0xAA); // Prime SPI with next reply
            //pc->printf("Life rxvd, next line will reply with 0xAA\n\r");
        }
        
        else if (valueFromMaster == 0x84) {
            spiLine->reply(0xAB);
            spiLine->reply(0xAC);
            //pc->printf("Life multiplyer, next line will reply with 2 x 0xBB\n\r");
        }
    }
}   