#include "spiMasterProtocol.h"

spiMasterProtocol::spiMasterProtocol() {
    spiLine = new SPI(p5, p6, p7);
    spiLine->format(8,3);        // Setup:  bit data, high steady state clock, 2nd edge capture
    spiLine->frequency(1000000); // 1MHz
    
    chipSelect = new DigitalOut(p8);
    chipSelect->write(1);
}
 
 int spiMasterProtocol::get42() {
    int temp = write(0x42);
    wait_us(5);
    int data = write(0x00);
    wait_us(5);
    int dataExtra = write(0x00);
    
    printf("get42():\n\r");
    printf("temp = %d\n\r", temp);
    printf("data = %d\n\r", data);
    printf("dataExtra = %d\n\r", data);
    printf("\n");
    
    return data;
}

 int spiMasterProtocol::get84() {
    int temp = write(0x84);
    wait_us(5);
    int data1 = write(0x00);
    wait_us(5);
    int data2 = write(0x00);
    
    printf("get84():\n\r");
    printf("temp = %d\n\r", temp);
    printf("data1 = %d\n\r", data1);
    printf("data2 = %d\n\r", data2);
    printf("\n");
    
    return data2;
}

int spiMasterProtocol::write(int m) {
    chipSelect->write(0);
    
    int returnMess = spiLine->write(m);
    
    chipSelect->write(1);
    
    return returnMess;
}