/*  xbeeutils.h
 *  Guillaume Hivert, Marc-Olivier Lavoie, Gabriel Gibeau-Sanchez
 *  Université de Sherbrooke, S5 project
 *
 *  Provides high-level functions to initialize and control xbee communication.
 *  Inspired by https://os.mbed.com/teams/Digi-International-Inc/code/XBeeLib/wiki/Discovering-nodes-in-the-network
*/

#ifndef XBEEUTILS_H
#define XBEEUTILS_H

#include "XBeeLib.h"
#include "ProcessControl.h"
//#include "EthCommunication.h"

using namespace XBeeLib;

void discover();
void xbee_init();
void send_data_to_coordinator(char *message, int length);
RemoteXBeeZB get_remote_node();
void xbee_send(const RemoteXBeeZB& xbzb, char * msg, int length);
void xbee_broadcast(char *message, int length);
void process_rx_frames();
int split (char *str, char c, char ***arr);

#endif