#include "ProcessControl.h"

static Config config;
static int updated = 0;

static DigitalOut light(p11); // pH -
static DigitalOut pKOH(p12); // pH -
static DigitalOut pH2PO4(p13); // pH +
static DigitalOut HydroBloom(p14); // Nutrients
static DigitalOut solValve(p15); // Nutrients
static DigitalOut drainPump(p16); // Nutrients
static DigitalOut nutPump(p17); // Nutrients
static Serial pc(USBTX,USBRX);



int getConfig(Config *conf) {
    if(updated) {
        conf = &config;
        return 1;
    } else {
        return 0;
    }
}

void initSystem(){
    light = 1;
    pKOH=1;
    pH2PO4=1;
    HydroBloom=1;
    solValve=1;
    drainPump=1;
    nutPump=1;

}


void setConfig(Config conf) {
    config = conf;
    updated = 1;
}

void drainSystem(){
    pc.printf("Drainage du systeme initie...\n");
    pc.printf("Overture valve et pompe...\n");
    solValve =0;
    drainPump=0;   
    
    
    for(int i=120;i>=0;i--){
        wait_ms(1000);
        pc.printf("drainage complet dans %i secondes\n",i);
    }
    solValve =1;
    drainPump=1;   
    pc.printf("Vidange complete\n");

}


double getTargetTemperature() {
    return (config.temperatureMin + config.temperatureMax)/2;
}

void watering(){
    nutPump =0;
    wait(60);
    nutPump =1;
}


double getTargetPh() {
    return (config.phMin + config.phMax)/2;
}

void adjustePh(){
    float ph=getPH();
    while(ph < getTargetPh()*1.1){
        pH2PO4 =0;
        wait_ms(1200);
        pH2PO4=1;
        wait_ms(7000);
        ph=getPH();
    }   
    while(ph > getTargetPh()*1.1){
        pKOH =0;
        wait_ms(1200);
        pKOH=1;
        wait_ms(7000);
        ph=getPH();
    }
}

double getTargetEc() {
    return config.ec;
}

void adjustEC(){
    float ec = getEC();
    while(ec<1.1*getTargetEc()){
        
    }
}
