#include "pH.h"

static I2C PH(p28,p27); // SDA / SCL
static Serial pc(USBTX,USBRX);

static DigitalOut led1(LED1);
static DigitalOut led2(LED2);
static DigitalOut led3(LED3);
static DigitalOut led4(LED4);

static char buf[DEFAULT_BUFFER_SIZE];
static char fBuf[DEFAULT_BUFFER_SIZE];

void init_PH(){
    PH.frequency(MAX_I2C_CLOCK);
    clearBuffer_PH();
}

void setAdresse_PH(uint8_t addresse ){
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('I');
    PH.write('2');
    PH.write('C');
    PH.write(',');
    PH.write(addresse);
    PH.stop();
}

void calibrate_PH(){ // Calibrate the PH AC converter at 
    pc.printf("Clearing pH sensor calibration...");    
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('C');
    PH.write('a');
    PH.write('l');
    PH.write(',');
    PH.write('c');
    PH.write('l');
    PH.write('e');
    PH.write('a');
    PH.write('r');
    PH.stop();
    
    wait_ms(300);
    
    pc.printf("pH senosr calibration cleared");    
    
    for(int i=120;i>0;i--){
        pc.printf("\r                                                           ");    
        pc.printf("\rCalibration de la sonde de pH en cours. Temps restants: %i secondes...",i);
        wait_ms(1000);
    }
    
    pc.printf("\n");    
    
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('C');
    PH.write('a');
    PH.write('l');
    PH.write(',');
    PH.write('m');
    PH.write('i');
    PH.write('d');
    PH.write(',');
    PH.write('7');
    PH.write('.');
    PH.write('0');
    PH.write('0');
    PH.stop();
    
    wait_ms(1600);
    
    getCalibrationStatus_PH();
}

void getCalibrationStatus_PH(){
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('C');
    PH.write('a');
    PH.write('l');
    PH.write(',');
    PH.write('?');
    PH.stop();
    
    wait_ms(300);
    PH.write(0x00);
    PH.read(PH_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        fBuf[i]=buf[i];
    }
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void find_PH   (){
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('F');
    PH.write('i');
    PH.write('n');
    PH.write('d');
    PH.stop();
}

void status_PH(){
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('S');
    PH.write('t');
    PH.write('a');
    PH.write('t');
    PH.write('u');
    PH.write('s');
    PH.stop();
    
    wait_ms(300);
    PH.write(0x00);
    PH.read(PH_ADRESSE<<1,buf,15);
    
    for(int i=0;i<15;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void sleep_PH(){
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('S');
    PH.write('l');
    PH.write('e');
    PH.write('e');
    PH.write('p');    
    PH.stop();
}

void read_PH(){
    
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('R');
    PH.stop();
    
    wait_ms(900);
    PH.write(0x00);
    PH.read(PH_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    int i =0;
    while(buf[i]!=0){
        pc.putc(buf[i]);
        i++;
    }
    pc.putc('\n');
    clearBuffer_PH();
}

float getPH(){
    
    char bufTmp[DEFAULT_BUFFER_SIZE];
    
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('R');
    PH.stop();
    
    wait_ms(900);
    PH.write(0x00);
    PH.read(PH_ADRESSE<<1,bufTmp,DEFAULT_BUFFER_SIZE);
    
    return atof(bufTmp+1);
}

void read_PH(char * buffer){
    
    PH.start();
    PH.write(PH_ADRESSE<<1);
    PH.write('R');
    PH.stop();
    
    wait_ms(900);
    PH.write(0x00);
    PH.read(PH_ADRESSE<<1,buffer,DEFAULT_BUFFER_SIZE);
}

void clearBuffer_PH(){
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        buf[i]=0;
    }
}