#include "Sensors.h"

static Serial pc(USBTX,USBRX);

void calibrateSensors(){
    
    pc.printf("Calibrating sensors...\n");
    
    //calibrate_EC();
    //calibrate_RTD();
    calibrate_PH();
    pc.printf("Calibration completed!\n");
}

void getReadings(){
    
    char phBuf[DEFAULT_BUFFER_SIZE], ECBuf[DEFAULT_BUFFER_SIZE], RTDBuf[DEFAULT_BUFFER_SIZE], TxBuf[DEFAULT_BUFFER_SIZE];
    
    read_EC(ECBuf);
    read_RTD(RTDBuf);
    read_PH(phBuf);
    
    sprintf(TxBuf,"%s;%s;%s",RTDBuf+1,phBuf+1,ECBuf+1);
    //sprintf(TxBuf,"%s;%s;%s;\0","1.1","2.2","3.3");
    pc.printf("%s\n",TxBuf);
    RemoteXBeeZB xbzb = get_remote_node();
    const RemoteXBeeZB& remoteDevice = xbzb;
    xbee_send(remoteDevice, TxBuf, strlen(TxBuf));
}