#include "RTD.h"

static I2C RTD(p28,p27); // SDA / SCL
static Serial pc(USBTX,USBRX);

static DigitalOut led1(LED1);
static DigitalOut led2(LED2);
static DigitalOut led3(LED3);
static DigitalOut led4(LED4);

static char buf[DEFAULT_BUFFER_SIZE];
static char fBuf[DEFAULT_BUFFER_SIZE];

void init_RTD(){
    RTD.frequency(MAX_I2C_CLOCK);
}

void setAdresse_RTD(uint8_t addresse ){
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('I');
    RTD.write('2');
    RTD.write('C');
    RTD.write(',');
    RTD.write(addresse);
    RTD.stop();
}

void calibrate_RTD(){ // Calibrate the RTD AC converter at 100°C

    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('C');
    RTD.write('a');
    RTD.write('l');
    RTD.write(',');
    RTD.write('c');
    RTD.write('l');
    RTD.write('e');
    RTD.write('a');
    RTD.write('r');
    RTD.stop();
    
    wait_ms(300);
    
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('C');
    RTD.write('a');
    RTD.write('l');
    RTD.write(',');
    RTD.write('2');
    RTD.write('1');
    RTD.write('.');
    RTD.write('8');
    RTD.stop();
    
    wait_ms(1000);
    
    getCalibrationStatus_RTD();
}

void getCalibrationStatus_RTD(){
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('C');
    RTD.write('a');
    RTD.write('l');
    RTD.write(',');
    RTD.write('?');
    RTD.stop();
    
    wait_ms(300);
    RTD.write(0x00);
    RTD.read(RTD_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        fBuf[i]=buf[i];
    }
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void find_RTD(){
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('F');
    RTD.write('i');
    RTD.write('n');
    RTD.write('d');
    RTD.stop();
}

void status_RTD(){
    
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('S');
    RTD.write('t');
    RTD.write('a');
    RTD.write('t');
    RTD.write('u');
    RTD.write('s');
    RTD.stop();
    
    wait_ms(300);
    RTD.write(0x00);
    RTD.read(RTD_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void sleep_RTD(){
    
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('S');
    RTD.write('l');
    RTD.write('e');
    RTD.write('e');
    RTD.write('p');    
    RTD.stop();
}

void getInfo_RTD(){
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('I');
    RTD.stop();
    
    wait_ms(300);
    RTD.write(0x00);
    RTD.read(RTD_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    int i=0;
    while(buf[i]!=0){
        pc.putc(buf[i]);
        i++;
    }
    pc.putc('\n');
}

void read_RTD(){
    
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('R');
    RTD.stop();
    
    wait_ms(600);
    RTD.write(0x00);
    RTD.read(RTD_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    int i=0;
    while(buf[i]!=0){
        pc.putc(buf[i]);
        i++;
    }
    pc.putc('\n');
    clearBuffer_RTD();
}

float getRTD(){
    
    char bufTmp[DEFAULT_BUFFER_SIZE];
    
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('R');
    RTD.stop();
    
    wait_ms(600);
    RTD.write(0x00);
    RTD.read(RTD_ADRESSE<<1,bufTmp,DEFAULT_BUFFER_SIZE);
    
    return atof(bufTmp+1);
}

void read_RTD(char * buffer){
    
    RTD.start();
    RTD.write(RTD_ADRESSE<<1);
    RTD.write('R'); 
    RTD.stop();
    
    wait_ms(600);
    RTD.write(0x00);
    RTD.read(RTD_ADRESSE<<1,buffer,DEFAULT_BUFFER_SIZE);
}


void clearBuffer_RTD(){
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        buf[i]=0;
    }
}