#include "EC.h"

static I2C EC(p28,p27); // SDA / SCL
static Serial pc(USBTX,USBRX);

static DigitalOut led1(LED1);
static DigitalOut led2(LED2);
static DigitalOut led3(LED3);
static DigitalOut led4(LED4);

char buf[DEFAULT_BUFFER_SIZE];
char fBuf[DEFAULT_BUFFER_SIZE];

void init_EC(){
    EC.frequency(MAX_I2C_CLOCK);
    clearFBuffer_EC();
    clearBuffer_EC();
}

void setAdresse_EC(uint8_t addresse ){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('I');
    EC.write('2');
    EC.write('C');
    EC.write(',');
    EC.write(addresse);
    EC.stop();
}

void calibrate_EC(){ // Executes Dry Calibrate of the EC AC
    
    char buf[10];
    
    EC.start();    
    EC.write(EC_ADRESSE<<1);
    EC.write('C');
    EC.write('a');
    EC.write('l');
    EC.write(',');
    EC.write('c');
    EC.write('l');
    EC.write('e');
    EC.write('a');
    EC.write('r');
    EC.stop();
    
    wait_ms(300);
    
    pc.printf("EC sensor calibration cleared\n");
    pc.printf("Press any key to start dry calibration - make sure the probe is completely dry...\n");
    pc.getc();
    pc.printf("Dry calibration started..\n");
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('C');
    EC.write('a');
    EC.write('l');
    EC.write(',');
    EC.write('d');
    EC.write('r');
    EC.write('y');
    EC.stop();
    
    wait_ms(2000);
    
    pc.printf("EC sensor dry calibration completed\n");
    pc.printf("Press any key to start one point calibration - make sure the probe is in 700 uS calibration solution...\n");
    pc.getc();
    
    pc.printf("One point calibration starting...\n");
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('C');
    EC.write('a');
    EC.write('l');
    EC.write(',');
    EC.write('o');
    EC.write('n');
    EC.write('e');
    EC.write(',');
    EC.write('7');
    EC.write('0');
    EC.write('0');
    EC.stop();
    
    pc.printf("One point calibration completed\n");
    
    wait_ms(1300);
    
    getCalibrationStatus_EC();
}

void getCalibrationStatus_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('C');
    EC.write('a');
    EC.write('l');
    EC.write(',');
    EC.write('?');
    EC.stop();
    
    wait_ms(300);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void setProbeType_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('K');
    EC.write(',');
    EC.write('0');
    EC.write('.');
    EC.write('1');
    EC.stop();
}

void getProbeType_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('K');
    EC.write(',');
    EC.write('?');
    EC.stop();
    
    wait_ms(600);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void find_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('F');
    EC.write('i');
    EC.write('n');
    EC.write('d');
    EC.stop();
}

void status_EC(){
    char buf[15];
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('S');
    EC.write('t');
    EC.write('a');
    EC.write('t');
    EC.write('u');
    EC.write('s');
    EC.stop();
    
    wait_ms(300);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buf,15);
    
    for(int i=0;i<15;i++){
        pc.putc(buf[i]);
    }
    pc.putc('\n');
}

void sleep_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('S');
    EC.write('l');
    EC.write('e');
    EC.write('e');
    EC.write('p');    
    EC.stop();
}

void getInfo_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('i');
    EC.stop();
    
    wait_ms(300);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    int i=0;
    while(buf[i]!=0){
        pc.putc(buf[i]);
        i++;
    }
    pc.putc('\n');
}

void read_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('R');
    EC.stop();
    
    wait_ms(600);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    /*
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        fBuf[i]=buf[i];
        wait_ms(100);
    }
    */
    int i=0;
    while(buf[i]!=0){
        pc.putc(buf[i]);
        i++;
    }
    pc.putc('\n');
    clearBuffer_EC();
}

void read_EC(char * buffer){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('R');
    EC.stop();
    
    wait_ms(600);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buffer,DEFAULT_BUFFER_SIZE);
}

float getEC(){
    
    char bufTmp[DEFAULT_BUFFER_SIZE];
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('R');
    EC.stop();
    
    wait_ms(600);
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,bufTmp,DEFAULT_BUFFER_SIZE);
    
    return atof(bufTmp+1);
}   

float getTDS(){
    
    float res=0,tmp=0;
    
    if(fBuf[0]!=0){
        int i=0;
        do{
            i++;
        }while(fBuf[i]!=',');
        pc.printf("i:%i\n",i);
        for(int j=1;j<i;j++){
            tmp=0;
            tmp=((fBuf[j] - 48));
            
            for(int k=0;k<(i-j-1);k++){
                tmp*=10;
            }
            res+=tmp;
            wait_ms(100);
        }
        wait_ms(1000);    
    }
    return res;
}

void clearBuffer_EC(){
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        buf[i]=0;
    }
}

void clearFBuffer_EC(){
    for(int i=0;i<DEFAULT_BUFFER_SIZE;i++){
        fBuf[i]=0;
    }
}

void parameterToECOnly(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('O');
    EC.write(',');
    EC.write('E');
    EC.write('C');
    EC.write(',');
    EC.write('1');
    EC.stop();
    wait_ms(500);
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('O');
    EC.write(',');
    EC.write('T');
    EC.write('D');
    EC.write('S');
    EC.write(',');
    EC.write('0');
    EC.stop();
    wait_ms(500);
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('O');
    EC.write(',');
    EC.write('S');
    EC.write(',');
    EC.write('0');
    EC.stop();
    wait_ms(500);
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('O');
    EC.write(',');
    EC.write('S');
    EC.write('G');
    EC.write(',');
    EC.write('0');
    EC.stop();
    wait_ms(500);
    
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('O');
    EC.write(',');
    EC.write('?');
    EC.write('\r');
    EC.stop();
    wait_ms(500);
    
    EC.write(0x00);
    EC.read(EC_ADRESSE<<1,buf,DEFAULT_BUFFER_SIZE);
    
    int i=0;
    while(buf[i]!=0){
        pc.putc(buf[i]);
        i++;
    }
    pc.putc('\n');
    clearBuffer_EC();
}

void FactorySettings_EC(){
    EC.start();
    EC.write(EC_ADRESSE<<1);
    EC.write('F');
    EC.write('a');
    EC.write('c');
    EC.write('t');
    EC.write('o'); 
    EC.write('r');
    EC.write('y');
    EC.stop();
    
    wait_ms(1000);
}
    