#include "mbed.h"

#include <map>

#include "PC_Com.h"
#include "Note.h"
#include "Engine.h"


InterruptIn* mybutton;
Engine* engine;

int requestTimer;
float delay = 1.0; // 1 sec

void pressed()
{
    static int nbPressed = 0;
    /*
    switch(nbPressed % 5) {
        case 0:
            engine->stopNote(Sol_0);
            engine->startNote(Do_0);
            break;
        case 1:
            engine->stopNote(Do_0);
            engine->startNote(Re_0);
            break;
        case 2:
            engine->stopNote(Re_0);
            engine->startNote(Mi_0);
            break;
        case 3:
            engine->stopNote(Mi_0);
            engine->startNote(Fa_0);
            break;
        case 4:
            engine->stopNote(Fa_0);
            engine->startNote(Sol_0);
            break;

    }
    */
    if(nbPressed%2 == 0) {
        engine->startNote(Do_0);
    } else {
        engine->stopNote(Do_0);
    }
    nbPressed++;
}

int main()
{
    int command = 0;
    //init
    mybutton = new InterruptIn(USER_BUTTON);
    mybutton->fall(&pressed);
    PC_Com::Init();
    //create the engine
    engine = new Engine(ON_TICK);
    engine->start();

    //main loop
    while (1) {
        PC_Com::Write("Insert command:\r");
        command = PC_Com::Read();
        switch(command) {
            case 1:
                PC_Com::Write("MAIN: start note\r");
                engine->startNote(Do_0);
                break;
            case 2:
                PC_Com::Write("MAIN: stop note\r");
                engine->stopNote(Do_0);
                break;
            default:
                //do nothing
                break;
        }
        wait(1);
    }

    engine->stop();
    delete(engine);
    PC_Com::Kill();
}
