
#include "mbed.h"
#include "PC_Com.h"

static Serial* pc;
static std::vector<std::string> inputParam;

bool PC_Com::Init()
{
    //init the serail port on USB
    pc = new Serial(USBTX, USBRX);
    //configure the communication
    pc->baud(115200);
    pc->format(8, SerialBase::None, 1);
    //pc->attach(this, &PC_Com::IrqHandling, pc->RxIrq);
    
    return true;
}


bool PC_Com::Kill()
{
    delete pc;
    return true;
}

bool PC_Com::Write(std::string stringToWrite)
{
    while (!pc->writeable()) {}; //Wait for the buffer to be empty
    pc->printf(stringToWrite.c_str());
    return true;
}

int PC_Com::Read(void)
{
    char buffer[128];
    std::string echoString;
    int iRet = 0;
    
    pc->gets(buffer, 128);
    //output it to serial
    echoString = buffer;

    //parse the string
    PC_Com::Split(inputParam, echoString, ' ');
    //for(int i = 0; i < inputParam.size(); ++i) {
    //    PC_Com::Write( PC_Com::toString(i) + " : '" + inputParam[i] + "'\r");
    //}

    if(inputParam.size() >= 1) {
        PC_Com::Write("Serial: contains at least 1 word\r");

        if(inputParam[0].compare("NOTE_ON") == 0) {
            if(inputParam.size() < 2) {
                PC_Com::Write("Serial: ERROR This command requiers a parameter\r");
            } else {
                //starts the desired note
                PC_Com::Write("Serial: start note " + inputParam[1] + "\r");
                iRet = 1;
            }
        } else {
            if(inputParam[0].compare("NOTE_OFF") == 0) {
                if(inputParam.size() < 2) {
                    PC_Com::Write("Serial: ERROR This command requiers a parameter\r");
                } else {
                    PC_Com::Write("Serial: stop note " + inputParam[1] + "\r");
                    iRet = 2;
                }
            } else {
                if(inputParam[0].compare("TEMPO") == 0) {
                    if(inputParam.size() < 2) {
                        PC_Com::Write("Serial: ERROR This command requiers a parameter\r");
                    } else {
                        //intParam = atoi(inputParam[1].c_str());
                        PC_Com::Write("Serial: change tempo to " + inputParam[1] + "\r");
                    }
                } else {
                    PC_Com::Write("Serial: no command found\r");
                }
            }
        }
    } else {
        //only one word was found
        PC_Com::Write("Serial: ERROR 1");
    }
    
    return iRet;
}

int PC_Com::Split(std::vector<string>& vecteur, std::string chaine, char separateur)
{
    vecteur.clear();

    std::string::size_type stTemp = chaine.find(separateur);

    while(stTemp != string::npos) {
        vecteur.push_back(chaine.substr(0, stTemp));
        chaine = chaine.substr(stTemp + 1);
        stTemp = chaine.find(separateur);
    }
//last string ->remove \r and \n
    stTemp = chaine.find('\r');
    if(stTemp != string::npos) {
        chaine = chaine.substr(0, stTemp);
    }
    stTemp = chaine.find('\n');
    if(stTemp != string::npos) {
        chaine = chaine.substr(0, stTemp);
    }
    vecteur.push_back(chaine);

    return vecteur.size();
}

std::string PC_Com::ToString(int i)
{
    std::string intToString;
    char idChar[10];

    snprintf(idChar, 10, "%i", i);
    intToString = idChar;

    return intToString;
}