#pragma once
#include "mbed.h"

//Notes have a corresponding PIN and a state
typedef enum {
    NOTE_OFF = 0,
    NOTE_ON = 1
} e_NoteState;

typedef enum {
    Do_0,
    Re_b_0,
    Re_0,
    Mi_b_0,
    Mi_0,
    Fa_0,
    Sol_b_0,
    Sol_0,
    La_b_0,
    La_0,
    Si_b_0,
    Si_0,
    
        NB_NOTES
} e_NoteName;


class Note
{

public:

    /** Creates a Note
    * A note has a state currently applied, but also a desired state which will be applied when applyDesiredState is called
    *  @param affectedPin which output will be changed to apply the state
    */
    Note(PinName affectedPin = NC);
    ~Note();

    /** Gets the current state of the output */
    e_NoteState getCurrentState();
    /** Gets the desired state of the output */
    e_NoteState getDesiredState();
    /** Sets the desired state */
    void setDesiredState(e_NoteState newState);

    /** apply the desired state to the output
    * application is done only when desired state and current state mismatches
    */
    bool applyDesiredState();

private:

    PinName correspondingPin;
    DigitalOut* outputPin;
    e_NoteState currentState;
    e_NoteState desiredState;

};
