#include "Note.h"
#include "PC_Com.h"

DigitalOut myled(LED1);

Note::Note(PinName affectedPin)
{
    //correspondingPin = affectedPin;
    outputPin = new DigitalOut(affectedPin, 1);
    currentState = NOTE_ON;
    desiredState = NOTE_ON;
}
Note::~Note()
{
    delete(outputPin);
}

e_NoteState Note::getCurrentState()
{
    return currentState;
}

e_NoteState Note::getDesiredState()
{
    return desiredState;
}
void Note::setDesiredState(e_NoteState newState)
{
    desiredState = newState;
}

bool Note::applyDesiredState()
{
    if(desiredState != currentState) {
        if(desiredState == NOTE_OFF) {
            PC_Com::Write("NOTE: OFF\r");
            //outputPin->write(NOTE_OFF);
            myled = 0;
            currentState = NOTE_OFF;
            PC_Com::Write("NOTE: WRITTEN\r");
        } else {
            PC_Com::Write("NOTE: ON\r");
            //outputPin->write(NOTE_ON);
            myled = 1;
            currentState = NOTE_ON;
            PC_Com::Write("NOTE: WRITTEN\r");
        }
        return true;
    }
    
    return false;
}