#pragma once
#include "mbed.h"
#include <map>
#include "PC_Com.h"
#include "Note.h"



typedef enum {
    ON_COMMAND, ///< The command is directly done
    ON_TICK    ///< Perform changes every time applyChanges is called
} e_modeOfUsing;

class Engine
{
public:
    /** Create the engine in charge of handling note activation
    *
    *  @param mode select if we directly apply the command or wait for a tick
    */
    Engine(e_modeOfUsing mode = ON_COMMAND);
    ~Engine();
    
    /**Starts the engine*/
    void start(void);
    /**Changes the Tempo
    * This will stops the timer, you have to restart it
    */
    void changeTempo(int newTempo);
    /**Stops the engine*/
    void stop(void);

    /** Start playing a note*/
    bool startNote(e_NoteName noteToStart);
    /** Stop playing a note*/
    bool stopNote(e_NoteName noteToStop);

private:
    
    Ticker tick; ///< link the note name with their instance
    e_modeOfUsing modeOfUsing;
    float tempo;
    Note notes[NB_NOTES]; ///< link the note name with their instance
    std::map<e_NoteName, Note>::iterator notesIterator;
    
    /** Converts a tempo into millisec
    * Used for defining the the timer tick
    */
    float ConvertTempo(int tempo);
    
    /** Cyclic function that will be called if mode = ON_TICK
    * this will apply all the changes done during 2 consecutives calls
    */
    void applyChanges(void);
};
