#include "mbed.h"
#include <map>
#include "Engine.h"

#define TEMPO_DEF 10.0


//DigitalOut myled(LED1);


Engine::Engine(e_modeOfUsing mode)
{
    modeOfUsing = mode;
    tempo = ConvertTempo(TEMPO_DEF);
  
    notes[Do_0] = Note(LED1);
    notes[Re_0] = Note();
    notes[Mi_0] = Note();
    notes[Fa_0] = Note();
    notes[Sol_0] = Note();

}
Engine::~Engine()
{

}

/**Starts the engine*/
void Engine::start(void)
{
    if(modeOfUsing == ON_TICK) {
        tick.attach(this,  &Engine::applyChanges, tempo);
    }
}
/**Changes the Tempo*/
void Engine::changeTempo(int newTempo)
{
    if(modeOfUsing == ON_TICK) {
        this->stop();
        tempo = ConvertTempo(newTempo);
    }
}
/**Stops the engine*/
void Engine::stop(void)
{
    if(modeOfUsing == ON_TICK) {
        tick.detach();
    }
}

void Engine::applyChanges()
{
    //show tempo on LED1
    //myled = !myled;

    for(int i = 0; i < NB_NOTES; i++) {
        if(notes[i].getCurrentState() != notes[i].getDesiredState()) {
            notes[i].applyDesiredState(); 
        }
    }

}

bool Engine::startNote(e_NoteName noteToStart)
{
    //try to find the desired note in the map
    if(noteToStart < NB_NOTES) {
        notes[noteToStart].setDesiredState(NOTE_ON);

        if(modeOfUsing == ON_COMMAND) {
            notes[noteToStart].applyDesiredState();
        }

        return true;
    } else {
        //note not found;
        return false;
    }
}


bool Engine::stopNote(e_NoteName noteToStop)
{

    if(noteToStop < NB_NOTES) {
        notes[noteToStop].setDesiredState(NOTE_OFF);
        if(modeOfUsing == ON_COMMAND) {
            notes[noteToStop].applyDesiredState();
        }
        return true;
    } else {
        //note not found
        return false;
    }
}

float Engine::ConvertTempo(int tempo)
{
    return (float)60.0/(float)tempo;
}
