/** @file xstp.h
 * @brief Construir paquetes XSTP.
 *
 * XSTP es un protocolo de telemetría que transfiere bytes arbitrarios
 */
#ifndef __XSTP_H
#define __XSTP_H

/** @addtogroup XSTP Protocolo XSTP
 *
 * XSTP es un protocolo de telemetría que transfiere bytes arbitrarios.
 *
 * Los datos son transferidos en formato big-endian (por alguna razón).
 *
 * @{ */

#define XSTP_MAXDATA 62

#include <stdint.h>

/** @brief Paquete de datos de XSTP. */
typedef struct {
    /** @brief Longitud de los datos */
    uint8_t len;
    /** @brief datos a enviar */
	uint8_t *data;
} XSTPPacket;

/** @brief Inicializa un paquete de datos normales
 * @param packet Paquete a inicializar
 * @param ssv Identificador del modelo del sensor*/
int buildSensorPacket(XSTPPacket *packet, uint8_t ssv);
/** @brief Inicializa un paquete que indica errores
 * @param ecode Código de error*/
int buildErrorPacket(XSTPPacket *packet, uint16_t ecode);
/** @brief Agrega datos a un paquete
 * @param sid Identificador del valor medido.
 * @param data Datos leídos.
 * @param len Longitud de \p data.*/
int attachSensor(XSTPPacket *packet, uint16_t sid, uint8_t *data, uint8_t len);
/** @brief Destructor de paquetes */
int freePacket(XSTPPacket *packet);

/** @} */

#endif /* XSTP_H */
